model Ex9_3
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>An 8% solution of a water soluble polymer (molecular weight =2000) is concentrated to 40% in a single-effect calandria evaporator at the rate of 2000 kg of feed per hour. The feed enters at 30 C and a vacuum of 600 mmhg is maintained in the evaporator. Saturated steam is available at a pressure of 8.0 bar absolute, but pressure may be reduced to a lower, if necessary, by throuttling. The following test data on the overall heat transfer coefficient are available.<div><br></div><div>delT(C) &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 30 &nbsp; &nbsp;35 &nbsp; &nbsp;40 &nbsp; &nbsp; 45 &nbsp; &nbsp;50 &nbsp; &nbsp;55 &nbsp; &nbsp;60 &nbsp; &nbsp;70 &nbsp; &nbsp;80 &nbsp; &nbsp;100</div><div>UD(W/m^2 C) 820 &nbsp;1145 1270 1325 620 780 &nbsp; 860 &nbsp;1000 640 &nbsp; 350</div><div><br></div><div>Calculate (i) The steam pressure to be used in the calandria</div><div>(ii) Heat transfer rate required</div><div>(iii)The steam required</div></body></html>"));
parameter Real Wf(unit="Kg/h")=2000"Mass flow rate of feed";
parameter Real xf=0.08"solute mass fraction in feed";
parameter Real xp=0.4"Solute mass fraction in product";
parameter Real BP(unit="K")=325"Boiling point of water at 660mmhg vacuum";
parameter Real Lv(unit="KJ/Kg")=2380"Latent heat of vaporization";
parameter Real R(unit="KJ/Kmol K")=8.314"Gas constant";
parameter Real M(unit="Kg/Kmol")=18"Molecular weight of solvent(water)";
parameter Real m(unit="Kg/Kmol")=2000"Molecular weight of solute(polymer)";
parameter Real Ps(unit="bar")=2.15"Pressure of steam from steam table";
parameter Real Hv(unit="KJ/Kg")=2607"Enthalpy of vapour";
parameter Real Cp(unit="KJ/Kg of solution C")=4.2"Specific heat capacity of solution";
parameter Real Tf(unit="C")=30"Temperature of feed";
parameter Real Tr(unit="C")=0"Reference Temperature";
parameter Real Ls(unit="KJ/Kg")=2188"Latent heat of vaporization of steam";
Real Ws(unit="Kg/h")"Solute mass flow rate";
Real Wp(unit="Kg/h")"Product flow rate";
Real Wv(unit="Kg/h")"Vapour flow rate";
Real BPE(unit="C")"Boiling point elevation";
Real BP_s(unit="C")"Boiling point of 40% solution";
Real Ts(unit="K")"Temperature of steam";
Real Hf(unit="KJ/Kg")"Enthalpy of feed";
Real Hp(unit="KJ/Kg")"Enthalpy of product";
Real Q(unit="KJ/hr")"Rate of heat transfer";
Real S(unit="Kg/hr")"Steam flow rate";
equation
//subdivision (i) 
//mass balance
Ws=(Wf*xf);
Ws=(Wp*xp);
Wv=(Wf-Wp);
//Boiling point elevation
BPE=(((R*(BP^2))/(Lv))*(((xp/(1-xp))*M)/(m)));
BP_s=(BP+BPE);
//When Temperature drop is 70C the the heat flux is minimum (From the table).
Ts=(BP_s+70);
//subdivision (ii)
Hf=(Cp*(Tf-Tr));
Hp=(Cp*((BP_s-273)-Tr));
Q=(((Wp*Hp)+(Wv*Hv))-(Wf*Hf));
//subdivision (iii)
S=(Q/Ls);
end Ex9_3;
