model Ex9_7
//Problem statements is given in the Documentation view
   annotation(
    Documentation(info = "<html><head></head><body>A single effect evaporator is used to concentrate 3000 kg/h of a dilute feed from 8% to 40% solute content. Besides labour charge, all other operating costs amount to 120000 per year. Low pressure ateam at 4.5 bar absolute is available at a cost of Rs700 per ton.<div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>Its is now planned to increase the capacity of the eveporator by maintaining a vacuum in the eveporator, so as to get the benifit of a larger driving force. Given below are the parameter values and operating conditions for both atmospheric and vacuum operation.</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>Assuming that the overall heat transfer coefficient coefficient remains constant, calculate the increaese in evaporation capacity attainable, and also the percentage change in the cost of concentrating a ton of feed. The specific heat of the dilute liquor is essentially the same as that of water, and the specific heat of the concentrated liquor is 0.764 Kcal/kg C. Because the solute has a high molecular weight, evavation of boiling point may be neglected. Heat of solution may aslo be neglected.</div></body></html>"));
  //All data are given in the problem statement
  parameter Real Wf(unit = "Kg/h") = 3000 "Feed flow rate";
  parameter Real xf = 0.08 "Solute mass fraction in feed";
  parameter Real Tf(unit = "C") = 60 "Feed temperature";
  parameter Real xp = 0.4 "Product flow rate";
  parameter Real Tr(unit = "C") = 0 "Reference temmperature";
  //Taken
  parameter Real Tp(unit = "C") = 100 "Temperature of product at 1 atm";
  parameter Real Cpf(unit = "Kcal/Kg") = 1 "Specific heat of feed";
  parameter Real Cpp(unit = "Kcal/Kg C") = 0.764 "Specific heat of product at 1 atm";
  parameter Real Hv(unit = "Kcal/Kg") = 639 "Enthalpy of vaporization of vapour at 1 atm";
  // from steam table
  parameter Real Ls(unit = "Kcal/kg") = 496 "Latent heat of vaporization of steam at 4.5 bar";
  // From steam table
  parameter Real Ts(unit = "K") = 425 "Temperature of steam";
  parameter Real C_s(unit = "Rs/ton") = 700 "Cost of steam per ton";
  parameter Real LC_1(unit = "Rs/h") = 100 "Labour cost per hour at 1 atm condition";
  parameter Real LC_v(unit = "Rs/h") = 200 "Labour cost per hour at vacuum condition";
  parameter Real OC_1(unit = "Rs/year") = 400000 "Other cost per year at 1 atm condition";
  parameter Real OC_v(unit = "Rs/year") = 600000 "Other cost per year at vacuum condition";
  parameter Real BP_v(unit = "C") = 47 "Boiing point of solution at 75 mmHg";
  parameter Real Hv_new(unit = "Kcal/kg") = 618 "latent heat of vapour at 75 mmHg";
  Real Ws(unit = "Kg/h") "Solute flow rate";
  Real Wp(unit = "Kg/h") "Product flow rate";
  Real Wv(unit = "Kg/h") "Vapour flow rate";
  Real Hf(unit = "Kcal/Kg") "Enthalpy of feed";
  Real Hp(unit = "Kcal/Kg") "Enthalpy of product";
  Real S_1(unit = "Kg/h") "Steam mass flow rate at 1 atm operating condition";
  Real Q_1(unit = "Kcal/hr") "heat flow rate at 1 atm operating condition";
  Real Q_v(unit = "Kcal/hr") "heat flow rate at 75mmHg operating condition";
  Real Ud_A(unit = "Kcal/C") "Product of Overall HTC and Area of heat transfer";
  Real CS_1(unit = "Rs/h") "Cost of steam per hour";
  Real TC_1(unit = "Rs/h") "Total cost per hour at 1 atm condition";
  Real CP_1(unit = "Rs/ton of feed") "Cost per feed of ton of feed at 1 atm condition";
  Real S_v(unit = "Kg/h") "Steam mass flow rate at vacuum condition";
  Real Wf_new(unit = "Kg/h") "New capacity under vacuum";
  Real Wv_new(unit = "Kg/h") "New flow rate of vapour under vacuum condition";
  Real PC(unit = "%") "Percentage increase in capacity";
  Real CS_v(unit = "Rs/h") "Cost of steam per hour at vacuum";
  Real TC_v(unit = "Rs/h") "Total cost per hour at vacuum condition";
  Real CP_v(unit = "Rs/ton of feed") "Cost per feed of ton of feed at vacuum condition";
  Real PS(unit = "%") "Percentage of cost saving on vacuum over 1 atm condition";
equation
//Mass balance
  Ws = Wf * xf;
  Ws = Wp * xp;
  Wv = Wf - Wp;
//Heat balance
  Hf = Cpf * (Tf - Tr);
  Hp = Cpp * (Tp - Tr);
  Wf * Hf + S_1 * Ls = Wp * Hp + Wv * Hv;
  Q_1 = S_1 * Ls;
  Ud_A = Q_1 / (Ts - 273 - Tp);
  CS_1 = S_1 / 1000 * C_s;
  TC_1 = CS_1 + LC_1 + OC_1 / (300 * 24);
//300 working day per year given
  CP_1 = TC_1 / (Wf / 1000);
//Under vacuum condition
  S_v * Ls = Ud_A * (Ts - (BP_v + 273));
//New capacity
//Heat balance
  Q_v = Ls * S_v;
  Wf_new * Hf + Q_v = (Wf_new - Wv_new) * (Cpp * (BP_v - Tr)) + Wv_new * Hv_new;
//Mass balance
  Wf_new * xf = (Wf_new - Wv_new) * xp;
//Percentage increase in capacity
  PC = (Wf_new - Wf) / Wf * 100;
//Cost calculation under vacuum condition
  CS_v = S_v / 1000 * C_s;
//There is a mistake in book in Steam cost calculation under vacuum condition
  TC_v = CS_v + LC_v + OC_v / (300 * 24);
  CP_v = TC_v / (Wf_new / 1000);
//Percentage of cost saving
  PS = (CP_1 - CP_v) / CP_1 * 100;
//Due to approximation in the book there is slight difference in the simulated result with the book ans
//Since there is a mistake in the book in Steam cost calculation under vacuum condition there is a significant difference between simulated value of "Percentage of cost saving" and the book ans
 end Ex9_7;
