model Ex2_2
  annotation(
    Documentation(info = "<html><head></head><body>The walls of a house in a Cold region consist of three layers, an outer brickwork of 15 cm thickness and an inner wooden panel of 1.2 cm thickness. The intermediate layer is made of an insulating material 7 cm thick. The thermal conductivities of the brick and wood used are 0.70 W/m C and 0.18 W/ m C, respectively. The inside and outside temperature of the composite wall are 21 C and -15 C respectively. If the layer of insulation offers twice the thermal resistance of the brick wall, Calculate<div>a) The rate of Heat loss per unit area of the wall&nbsp;</div><div>b) The thermals conductivity of the insulating material.</div></body></html>"));
//Problem statements is given in the Documentation view
  Real R1(unit = "C/W") "Resistance to Heat transfer by Brick";
  Real R2(unit = "C/W") "Resistance to Heat transfer by Insulation";
  Real R3(unit = "C/W") "Resistance to Heat transfer by wood";
  Real K2(unit = "W/m C") "Themal Conductivity Insulation";
  Real Q(unit = "W") "Heat transfer rate";
  parameter Real l1(unit = "m") = 0.15 "Thickness of the Brick";
  parameter Real l2(unit = "m") = 0.07 "Thickness of the Insulation";
  parameter Real l3(unit = "m") = 0.012 "Thickness of the wood";
  parameter Real K1(unit = "W/m C") = 0.70 "Themal Conductivity of Brick";
  parameter Real K3(unit = "W/m C") = 0.18 "Themal Conductivity of wood";
  parameter Real Tin(unit = "C") = 21 "Inside Temperature";
  parameter Real Tout(unit = "C") = -15 "Outside Temperature";
equation
  R1 = l1 / K1;
  R3 = l3 / K3;
  R2 = 2 * R1;
/*Sub division a */
  Q = (Tin - Tout) / (R1 + R2 + R3);
/*Sub division b */
  R2 = l2 / K2;
  //There may be a chance of slight changes in the ans from book due to the approximation in the book ans
end Ex2_2;
