model Ex4_3
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A 0.724 mm diameter nichrome heating wire carries a current of 8.3 amperes. The wire hs an electrical resistance of 2.625 Ohm/m. Air across the heated wire at a velosity of 10 m/s. If the bulk air temperature is 27 C and the pressure is essentially atmospheric, What will be the temperature of the wire at steady state?</body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
// Properties are taken at bulk air temperature initially,Since the temperature of the wire is not known
//Once the wire temperature is found out the properties are taken at mean temperature, once again the same procedure is repeated unit no significance improment can be done
//According to the book solution at the end of the second Iteration The solution is converged
//First element in array conatins Value with respect to bulk air temoperature, second element contains value with respect to the mean temperature
parameter Real[2] density(unit="kg/m^3")={1.1774,0.878}"Density of air";
parameter Real[2] Cp(unit="J/kg C")={1005.7,1014}"Specific heat of air";
parameter Real[2] viscosity(unit="Kg/m s")={1.983*(10^(-5)),2.3*(10^(-5))}"Viscosity of air";
parameter Real[2] k(unit="W/m C")={0.02624,0.0338}"Thermal conductivity of air";
parameter Real V(unit="m/s")=10"Velosity of bulk air";
parameter Real d(unit="m")=(7.24*(10^(-4)))"Diameter of wire";
parameter Real R(unit="Ohm")=2.625"Electrical Resistance";
parameter Real I(unit="Amperes")=8.3"Electrical current";
parameter Real Ta(unit="C")=27"Temperature of air";
Real A(unit="m^2")"Convective area";
Real[2] Re(unit="Dimension less")"Reynolds Number";
Real[2] Pr(unit="Dimension less")"Prandtl Number";
Real[2] Nu(unit="Dimension less")"Nusselt Number";
Real[2] h(unit="W/m^2 C")"Heat Transfer coefficient";
Real Q(unit="W")"Rate of Heat transfer";
Real[2] T(unit="C")"Temperature of the wire";
equation
//Forced convection is taking olace
//It is valid to make an assumption that the rate at which heat generated by the electric wire is equal to the heat transfer rate
//H.T.C csn be found out with the suitable correlation
//Conculation is based on a meter length of the wire
A= pi*d*1;  // Area of 1 m length wire
Q=(I^2)*R;
//Iteration 
for i in 1:2 loop
Re[i]=(d*V*density[i]/viscosity[i]);
Pr[i]=(Cp[i]*viscosity[i]/k[i]);
//To find out Heat transfer Coefficient "Churchill-Burnstein Correlation is used"
Nu[i]=(0.3+(((0.62*(Re[i]^0.5)*(Pr[i]^(1/3)))/((1+((0.4/Pr[i])^(2/3)))^(1/4)))*((1+((Re[i]/(2.82*10^5))^(5/8)))^(4/5))));
Nu[i]=((h[i]*d)/k[i]);
Q=(h[i]*A*(T[i]-Ta));
end for;
// in the book there is a mistake in calculating prandtl number in the second iteration
//Since there is no significnt difference between two iteration in the valae of Temperature of wire, The obtained value to taken as the converged value
end Ex4_3;
