model Ex4_6
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Lubricating oil used in the gearbox of a 14000 rom high speed blower is being recycled continuously through a bouble pipe counterflow heat excahnger for cooling. The oil is to be cooled from 70 C to 40 C at the rate of 1000 kg/h using water entering at 28 C. The water temperature at the exit should not exceed 42 C. The specific heat of oil is 2.05 KJ/Kg C. and that of water is 4.17 KJ/kg C. Calculate the required rate of the flow of water. If the heat excahnge area is 3 m^2, calculate the overall heat transfer coefficient.</body></html>"));
parameter Real mo(unit="kg/h")=1000"Flow rate of oil";
parameter Real Cpo(unit="KJ/kg C")=2.05"Specific heat of oil";
parameter Real Cpw(unit="KJ/Kg C")=4.17"Specific heat of water";
parameter Real Toi(unit"C")=70"Inlet temperature of oil";
parameter Real Too(unit="C")=40"Outlet temperature of oil";
parameter Real Twi(unit="C")=28"Inlet temperature of water";
parameter Real Two(unit="C")=42"Outlet temperature of water";
parameter Real A(unit="m^2")=3"Heat transfer area";
Real mw(unit="kg/h")"Flow rate of water";
Real Q(unit="Kw")"Heat transfer rate";
Real U(unit="W/m^2 C")"Overall heat Transfer coefficient";
equation
(mo*Cpo*(Toi-Too))=(mw*Cpw*(Two-Twi));
Q=(mo/3600)*Cpo*(Toi-Too);
(Q*1000)=(U*A*(((Toi-Two)-(Too-Twi))/(log((Toi-Two)/(Too-Twi)))));
//due to the approximation in the book the is slight variation in the simulated value
end Ex4_6;
