model Ex5_4
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A horizonral steam pip, 78 mm i.d and 89 mm o.d carries saturated steam at 15 kg/cm63 gauge pressure. It is lagged only with a 2 cm thick layer of pre-formed mineral fibre of therma;l conductivity 0.05 W/m C whch is exposed to ambient air at 25 C. Calculate the rate of heat loss by free convection per meter length of the pipe.</body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
// data are taken from the book
parameter Real[2] Tsa(unit="C")={50,70} "Assumed Temperature of insulation skin";
parameter Real l(unit="m")=1"Length of the pipe";
parameter Real kc(unit="W/m C")=0.05"Thermal conductivity of insulation";
parameter Real Ti(unit="C")=200.5"Steam temperature";  // From steam table for 15 kg/cm^2 pressure
parameter Real Ta(unit="C")=25"Ambient air temperature";
parameter Real id(unit="m")=0.078"Inner diameter of pipe";
parameter Real od(unit="m")=0.089"Outer diameter of pipe";
parameter Real t(unit="m")=0.02"Thickness of the insulation";
parameter Real[2] ki_vis(unit="m^2/s")={(1.76*10^(-5)),(1.8*(10^(-5)))}"Kinamatic viscosity"; 
parameter Real[2] Pr={0.705,0.703}"Prandtl Number";
parameter Real[2] k(unit="W/m C")={0.027,0.0275}"Thermal Conductivity of air";
parameter Real g(unit="m/s^2")=9.8"Gravitational accelaration";
Real ri(unit="m")"inner radius of insulation";
Real ro(unit="m")"Outer radius of insulation";
Real[2] Q(unit="W")"Heat transfer rate ";
Real[2] Ts(unit="C")"Skin temperature";
Real[2] h(unit="W/m^2 C")"Heat transfer coefficient";
Real[2] Gr"Grashof Number";
Real[2] Ra"Rayleigh Number";
Real[2] Tf(unit="K")"Film Temperature";
Real[2] beta(unit="K^-1")"Thermal expansion coefficient";
equation
ri=(od/2);
ro=(ri+t);
for i in 1:2 loop
Q[i]=(2*pi*l*kc*(Ti-Tsa[i])/(log(ro/ri)));
Tf[i]=((Tsa[i]+Ta)/2)+273;
beta[i]=(1/Tf[i]);
Ra[i]=Gr[i]*Pr[i];
Gr[i]=(g*beta[i]*(Tsa[i]-Ta)*((2*ro)^3)/(ki_vis[i]^2));
(h[i]*(2*ro)/k[i])=(0.6+((0.387*(Ra[i])^(1/6))/((1+(0.559/Pr[i])^(9/16))^(8/27))))^2;
Q[i]=(pi*2*ro*l*h[i]*(Ts[i]-Ta));
end for;
//There are three iterations are done in book. In the third iteration The assumed value of skin temperature and obtained value are same. Since the data are not given in book for the third  iteration, That cannot be simulated
//The value of rate of heat transfer is in Q(array).
end Ex5_4;
