model Ex6_1
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Consider nucleate pool boiling of ethyl acetate at 1 atm pressure,<div>(a) If the superheat in liquid is 5 C, Calculate teh diameter of a cavity on the boiling surface which produces a bubble nucleus that does not collapse after release from the surface.</div><div>(b) If a cavity has a radius of 1 micro meter, what degree of superheat is necessary so that a bubble nucleus grows in size after detachment from the cavity.&nbsp;</div></body></html>"));
  //Data are given in the problem statement
  parameter Real Ts(unit = "C") = 5 "Super heated Temperature of liquid";
  parameter Real rc(unit = "m") = 1 * 10 ^ (-6) "given Radius of the cavity";
  parameter Real Tsat(unit = "C") = 77 "boiling point of ethyl acetate";
  parameter Real Lv(unit = "J/kg_mol K") = 3.3605 * 10 ^ 7 "Molar Heat of vaporization";
  parameter Real R(unit = "m^3 bar/ kg_mol K") = 0.08314 "Universal gas constant";
  Real Tl(unit = "C") "Temperature of liquid";
  Real pl(unit = "bar") "vapour Pressure of ethyl acetate";
  Real sur_ten(unit = "N/m") "Surface tension of liquid";
  Real r(unit = "m") "radius of the cavity";
  Real d(unit = "m") "Diameter of the cavity";
  Real degree_sup_heat(unit = "C") "Degree of super heating needed";
  Real Tl2(unit = "C") "Temperature of liquid as per sub division (b)";
  Real pl2(unit = "bar") "Vapour pressure of liquid as per subdivision (b)";
  Real sur_ten2(unit = "N/m") "Surface tension of liquid as per subdivision (b)";
equation
//subdivision (a)
  Tl = Tsat + Ts;
  log10(pl) = 4.22658 - 1244.95 / (Tl + 217.88);
// Antoine equation
  sur_ten = (26.29 - 0.1161 * Tl) * 10 ^ (-3);
  Tl - Tsat = 2 * sur_ten / (r * pl) * (R * (Tsat + 273) ^ 2 / Lv);
  d = 2 * r;
//Ans is in the variable r
// In book the diameter of the cavity is not found. Diameter is in variable d
//subdivision (b)
  log10(pl2) = 4.22658 - 1244.95 / (Tl2 + 217.88);
// Antoine equation
  sur_ten2 = 0.02629 - 1.161 * 10 ^ (-4) * Tl2;
  Tl2 - Tsat = 2 * sur_ten2 / (rc * pl2) * (R * (Tsat + 273) ^ 2 / Lv);
  degree_sup_heat = Tl2 - Tsat;
//Degree of super saturation needed as per the problem statement in subdivision (b) is represended by degree_sup_heat
//Due to the approximatio in book there is a slight difference in the value of degree of super saturation
end Ex6_1;
