model Ex6_6
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Trichloroethylene (TCE) is an important solvent (It is a carcinogen) for various application (The major uses are for cleaning and degreasing). A manufaturer of porous battery separtors uses it to leach out a non-volatile oil dispersed in the moulded PVC sheets in order to generate pores. TCE is recovered by stripping it out of the solution contining the oil followed by condensation.<div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>Condensation of vapour leaving the stripper is done in a horizontal condenser at essentially the atmospheric pressure. The vapour, which is of virtually pure TCE, condenses on the outside of 25.4 mm od tubes having a surface temperature of 25 C.</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>Calculate the rate of condensation of TCE&nbsp;</div><div>(a) on &nbsp;single horizontal tube, 0.7 m long and</div><div>(b) in a condenser that has 36 tubes of the same diameter and length, but arranged in a 38 mm square pitch</div></body></html>"));
 final constant Real pi=2*Modelica.Math.asin(1.0); 
// Data are given in the question statement
parameter Real Tv(unit="C")=87.4"Normal boiling point";
parameter Real Lv(unit="KJ/kg")=320.8"Latent Heat of vaporization";
parameter Real Cp(unit="KJ/kg C")=1.105"Specific heat of vaporation";
parameter Real viscosity(unit="Kg/m S")=4.5*10^(-4)"Viscosity of liquid";
parameter Real k(unit="W/m C")=0.1064"Thermal conductivity of liquid";
parameter Real density(unit="kg/m^3")=1375"Density of liquid";
parameter Real ro_v(unit="kg/m^2")=4.44"Density of vapour";
parameter Real Tw(unit="C")=25"Tube surface temperature";
parameter Real d(unit="m")=0.0254"Inner diameter";
parameter Real L(unit="m")=0.7"Length of the tube";
parameter Real N=6"Number of tube in a tier";
parameter Real n=36"Total number of tubes";
parameter Real g(unit="m/s^2")=9.8"Gravitational acceleration";
Real Tf(unit="C")"Film temperature";
Real Lv1(unit="KJ/kg")"Modified Latent Heat of vaporization";
Real h(unit="W/m^2 C")"Heat transfer coefficient of single tube";
Real A(unit="m^2")"Heat transfer area of single tube";
Real Q(unit="W")"Heat transfer rate on single tube";
Real m(unit="Kg/h")"Rate of condensation on single tube";
Real h1(unit="W/m^2 C")"H.T.C on vertical tier of N horizontal tubes";
Real Q1(unit="W")"Heat transfer rate on vertical tier of horizontal tubes";
Real m1(unit="kg/h")"Rate of condensation on 36 tubes";
equation
//Subdivision (a)
Tf=(Tv+Tw)/2;
Lv1=(Lv+(0.68*Cp*(Tv-Tw)));
h=(0.728*(((g*density*(density-ro_v)*(k^3)*(Lv1*1000))/(d*viscosity*(Tv-Tw)))^(1/4)));
A=(pi*d*L);
Q=(h*A*(Tv-Tw));
(m/3600)=(Q/(Lv1*1000));
//subdivision (b)
h1=(0.728*(((g*density*(density-ro_v)*(k^3)*(Lv1*1000))/(N*d*viscosity*(Tv-Tw)))^(1/4)));
Q1=(h1*n*A*(Tv-Tw));
(m1/3600)=(Q1/(Lv1*1000));
//Since, in book roundoff ans is used, there is a slight variation in the simuleted ans with the book
end Ex6_6;
