model Ex7_13
//Problem statements is given in the Documentation view
annotation(
    Documentation(info = "<html><head></head><body>A schedule 40 pipe (od=114 mm) carrying saturated steam at 7.33 bar absolute runs through a room having a wall temperature 27 C. The insulation on a section of the pipe has been damaged exposing the pipe wall to the ambient. Calculate the net rate of heat loss from unit length of the bare pipe by radiation if (a) the pipe surface is considered black, (b) the pipe surface has an emissivity of 0.74 (which is the emissivity of oxidized carbon steel)</body></html>"));
parameter Real F12(unit="No units")=1 "Fraction of radiation emitted form the surface 1 to 2";
parameter Real E1(unit="No units")=1 "Emissivity of black body";
parameter Real E2(unit="No units")=0.74 "Emissivity";
parameter Real T1(unit="K")=440 "Steam Temperature";
parameter Real T2(unit="K")=300 "Wall temperature";
parameter Real D(unit="mm")=114 "Outer diameter";
parameter Real S(unit="W/m^(4)")=5.67*10^(-8) "Stefan Boltzmann constant";
Real A(unit="m^2") "Area per unit length";
Real Q1(unit="W") "Net rate of heat loss if the pipe surface is black";
Real Q2(unit="W") "Net rate of heat loss if the pipe is non black";
equation
A=(D/1000)*3.14;
//subdivision (a)
Q1=(A*E1*S)*(T1^(4)-T2^(4));
//subdivision (a)
Q2=(A*E2*S)*(T1^(4)-T2^(4));
end Ex7_13;
