model Ex7_18
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A 2.54 cm o.d tube is used to transport a cryogenic liquid at -196 C, from a plant to an djacent unit. The tube is enclosed in an evacuated concentric pipe of 52. 5 mm i.d. having a wall temperature of -3 C. A thin-walled radiation shield is placed midway in the annular region between the tube and the pipe. Calculate the rate of heat gain by the liquid per metre length of the tube. The following emissivity data are available: Tube wall=0.05 ;pipe wall=0.1; inner surface of the radiation shield=0.02; Outer surface of the radiation shield =0.03.</body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real do(unit="m")=0.0525"inner diameter of pipe(encloser)";
parameter Real di(unit="m")=0.0254"Outer diameter of tube";
parameter Real Eo=0.1"Emissivity of pipe wall";
parameter Real Eso=0.03"Emissivity of outer surface of radiation shield";
parameter Real Esi=0.02"Emissivity of inner surface of the radiation shield";
parameter Real Ei=0.05"Emissivity of tube wall";
parameter Real L(unit="m")=1"length of the pipe or tube";
parameter Real To(unit="K")=270"Temperature of pipe";
parameter Real Ti(unit="K")=77"Temperatur of tube";
parameter Real Fso=1"View factor shield-pipe";
parameter Real Fis=1"View factor tube-shield";
parameter Real SB(unit="W/m^2 K^4")=5.669*10^(-8)"Stefan boltzmann constant";
Real ds(unit="m")"Diameter of shield";
Real Ao(unit="m^2")"surface Area pipe";
Real Ai(unit="m^2")"Surface area of tube";
Real As(unit="m^2")"Surface area of shield";
Real Fos"View factor pipe-shield";
Real Fsi"View factor shield-tube";
Real Qos(unit="W")"Heat transfer rate from pipe to shield";
Real Qsi(unit="W")"Heat transfer rate from shield to tube";
Real Ts(unit="K")"Temperature of shield";
equation
ds=(di+do)/2;
Ao=(pi*do*L);
Ai=(pi*di*L);
As=(pi*ds*L);
//View factor
(Ao*Fos)=(As*Fso);
(As*Fsi)=(Ai*Fis);
//Heat transfer rate
Qos=((Ao*SB*((To^4)-(Ts^4)))/(((1-Eo)/Eo)+(1/Fos)+((Ao/As)*((1-Eso)/Eso))));
Qsi=((As*SB*((Ts^4)-(Ti^4)))/(((1-Esi)/Esi)+(1/Fsi)+((As/Ai)*((1-Ei)/Ei))));
//At steady state
Qos=Qsi;
//Due to approximation in the book calculation there is slight variation in the simulated result with the book ans
end Ex7_18;
