model Ex7_21
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Hot flue gas containing 8% carbon dioxide, 15.2 % moisture, and the rest nitrogen and oxygen leaves a natural gas burner at 1100 C and flows through a 40 cm * 40 cm refractory lined square duct having a wall temperature of 800 C. Calculate the rate of heat transfer from the gas to the walls of the duct per meter length by combined radiation and forced convection. The convective heat transfer coefficent is 15 W/m^2 C. The walls can be assumed to be black and the pressure is essentially atmosheric.</body></html>"));
//Mentioned graph are from "Heat transfer principles and applications" by Binay K Dutta
parameter Real y_co2=0.08"Mole fraction of co2";
parameter Real y_moisture=0.152"Mole fraction of Moisture";
parameter Real Pt(unit="atm")=1"Total pressure";
parameter Real l(unit="m")=1"Length of the duct";
parameter Real a(unit="m")=0.4"width of the square duct";
parameter Real Tg(unit="K")=1373"Temperature of gas";
parameter Real Ts(unit="K")=1073"Temperature of surface";
parameter Real E_co2=0.06"Emissivity of co2";  //From graph 7.37
parameter Real E_moisture=0.048"Emissivity of moisture";  //From graph 7.38
parameter Real E_co2_1=0.068"Emissivity of co2 retaken";  //From graph 7.37
parameter Real E_moisture_1=0.069"Emissivity of moisture retaken";  //From graph 7.38
parameter Real delE=0.003"Correction emissivity"; // From fig 7.39
parameter Real Cc=1"Correction factor";
parameter Real Cw=1"Correction factor";
parameter Real h(unit="W/m^2 C")=15"Convective Heat transfer coefficient";
parameter Real SB(unit="W/m^2 K^4")=5.669*10^(-8)"Stefan boltzmann constant";
Real p_co2(unit="atm")"Partial pressure of co2";
Real p_moisture(unit="atm")"partial pressure of moisture";
Real V(unit="m^3")"Volume of the duct";
Real A(unit="m^2")"Surface area of the duct";
Real Le(unit="m")"Mean beam length";
Real Eg"Corrected emissivity of gas at Tg";
Real alpha_g"Correction factor at Ts";
Real Q_rad(unit="KW")"Heat transfer rate by radiation";
Real Q_conv(unit="KW")"Heat transfer rate by convection";
Real Q(unit="KW")"Total Heat transfer rate";
equation
p_co2=(y_co2*Pt);
p_moisture=(y_moisture*Pt);
V=(a*a)*l;
A=(4*a)*l;
Le=(3.6*(V/A));
//Emissivity of gas
Eg=E_co2+E_moisture-delE;
alpha_g=((Cc*E_co2_1*((Tg/Ts)^0.65))+(Cw*E_moisture_1*((Tg/Ts)^0.45))-(delE));
//Heat transfer rate
(Q_rad*1000)=(A*SB*((Eg*(Tg^4))-(alpha_g*(Ts^4))));
(Q_conv*1000)=(h*A*(Tg-Ts));
Q=Q_rad+Q_conv;
end Ex7_21;
