model Ex7_3
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>The sun may be considered to be a black body with a surface temperature of 5780 K. Calculate&nbsp;<div>(a) The fraction of solar radiation that falls in the visible range</div><div>(b) The fraction that occurs on the left of the visible range (lamda&lt;0.4 micro meter)</div><div>(c) The fraction that occurs on the right of the visible range (lamda&gt;0.7 micro meter)</div><div>(d) The wavelength and frequency of maximum spectral emissive power</div><div>(e) The maximum spectral emissive power</div><div>(f) The hemisperical total emissive power</div></body></html>"));
 final constant Real pi=2*Modelica.Math.asin(1.0);
 final constant Real e=Modelica.Math.exp(1.0);
parameter Real lamda1(unit="micro meter")=0.4"wave leangth of visible light, lower range";
parameter Real lamda2(unit="micro meter")=0.7"wave leangth of visible light, upper range";
parameter Real Fb1=0.1229"Fraction of radiation lower limit";  //From table 7.2 (p.no-213) Heat trasnfer principles and applications by Binay K dutta
parameter Real Fb2=0.4889"Fraction of radiation upper limit";  //From table 7.2 (p.no-213) Heat trasnfer principles and applications by Binay K dutta 
parameter Real T(unit="K")=5780"Surface temperature of black body";
parameter Real c(unit="m/s")=2.998*10^(8)"Speed of light";
parameter Real h(unit="J S")=6.626*10^(-34)"Plank's constant";
parameter Real k(unit="J/k")=1.3805*10^(-23)"Boltzmann constant";
parameter Real SB(unit="W/m^2 K^4")=5.669*10^(-8)"Stefan boltzmann constant";
Real Fb12"Fraction of radiation corresponds to wavelength 1-2";  
Real Fb01"Fraction of radiation correspomds to wavelength lesser than wavelength 1";
Real Fb2in"Fraction of radiation correspomds to wavelength greater than wavelength 2";
Real lamda_max(unit="micro meter")"wavelength of max emision";
Real f_max(unit="sec^-1")"Frequency of maximum spectrum emission power";
Real Eb_max(unit="W/m^2 m")"Max spectral emissive power";
Real Eb(unit="W/m^2")"Total emisive power";
equation
//Subdivision (a)
Fb12=Fb2-Fb1;
//Subdivision (b)
Fb01=Fb1;
//Subdivision (c)
Fb2in=(1-Fb2);
//Subdivision (d)
(lamda_max*T)=2898;
f_max=((c)/(lamda_max*(10^(-6))));
//Subdivision (e)
Eb_max=((2*pi*h*(c^2)*((lamda_max*(10^(-6)))^(-5)))/((e^((h*c)/((lamda_max*(10^(-6)))*k*T)))-1));
//Subdivision (f)
Eb=(SB*(T^4));
end Ex7_3;
