model Ex9_4
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>An aqueous solution of a high molecular weight solute is concentrated from 2% to 35% by weight at the rate of 6000 Kg/h in a forward-feed, double-effect evaporator. The dilute feed at 50 C enters the firat effect. Satrated steam at an absolute pressure of 2.0 bar is supplied to the first effent, while an absolute pressure of 0.0139 bar is maintained in the second effect. Saturated condensate is removed from each effect. The oveall heat transfer coefficient in the first and the second effect are 2000 W/m^2 K and 1500 W/m^2 H, respectively. Calculate the evaporator areas and the steam economy. The specific heat of the liquid can be taken as 4,1 KJ/Kg K.</body></html>"));
parameter Real Wf(unit="Kg/h")=6000"Mass flow rate of feed";
parameter Real xf=0.02"Solute mass fraction of feed";
parameter Real xp=0.35"Solute mass fraction in product";
parameter Real Ts(unit="C")=120"Temperature of saturated steam";
parameter Real Tp2(unit="C")=12"Operating temperature in second effect";
parameter Real Ls(unit="KJ/Kg")=2200"Latent heat of vaporization of saturated steam";
parameter Real U1(unit="W/m^2 K")=2000"Overall heat transfer coefficient for effect 1";
parameter Real U2(unit="W/m^2 K")=1500"Overall heat transfer coefficient for effect 2";
parameter Real Cpf(unit="KJ/kg C")=4.1"Specific heat of feed";
parameter Real Tf(unit="C")=50"Feed temperature";
parameter Real[2] Lv1(unit="KJ/Kg")={2330,2335}"latent heat of vaporization in first effect";
parameter Real[2] Lv2(unit="KJ/kg")={2470,2470}"Latent heat of vaporization in second effect";
Real Ws(unit="Kg/h")"Solute mass flowrate";
Real Wp(unit="Kg/h")"Product mass flow rate";
Real Wwp(unit="Kg/h")"Water flow rate in product stream";
Real Wwf(unit="Kg/h")"water flow rate in feed stream";
Real Wv_T(unit="Kg/h")"Total evaporation rate";
Real delT_T(unit="C")"Total temperature drop";
Real[2] delT1(unit="C")"Temperature difference in effect 1";
Real[2] delT2(unit="C")"Temperature difference in effect 2";
Real[2] T1(unit="C")"Temperature of saturated vapour leaving effect 1";
Real[2] T2(unit="C")"Temperature of saturated vapour leaving effect 2";
Real[2] Hf(unit="KJ/Kg")"Enthalpy of feed";
Real[2] Hp1(unit="KJ/Kg")"Enthalpy of product 1";
Real[2] Hv1(unit="KJ/Kg")"Enthalpy of vapour 1";
Real[2] Hp2(unit="KJ/Kg")"Enthalpy of product 2";
Real[2] Hv2(unit="KJ/Kg")"Enthalpy of vapour 2";
Real[2] Tr1(unit="C")"Reference temperature for effect1";
Real[2] Tr2(unit="C")"Reference temperature for effect 2";
Real[2] S(unit="C")"Steam flow rate";
Real[2] Wv1(unit="Kg/h")"Vapour flow rate in effect 1";
Real[2] Wv2(unit="Kg/h")"Vapour flow rate in effect 2";
Real[2] A1(unit="m^2")"Heat transfer area of effect 1";
Real[2] A2(unit="m^2")"Heat transfer area of effecr 2";
Real A(unit="m^2")"Area of heat transfer in each effect";
Real SE(unit="Kg of vapour produced/kg of steam supplied");
equation
//mass balance 
Ws=(Wf*xf);
Ws=(Wp*xp);
Wwf=(Wf-Ws);
Wwp=(Wp*(1-xp));
Wv_T=(Wf-Wp);
//Energy balance
delT_T=(Ts-Tp2);
delT_T=(delT1[1]+delT2[1]);
delT1[2]=48; //taken for the second iteration
delT2[2]=60;  //taken for the second iteration
//Lets consider area in both effects are same
(U1*delT1[1])=(U2*delT2[1]);
for i in 1:2 loop
T1[i]=Ts-delT1[i];
T2[i]=T1[i]-delT2[i];
Tr1[i]=T1[i];
Hf[i]=(Cpf*(Tf-Tr1[i]));
//For effect 1
Hp1[i]=0;//Reference temperature and product temperature are same in first effect 
Hv1[i]=Lv1[i];
((Wf*Hf[i])+(Ls*S[i]))=((Wv1[i]*Hv1[i]));  //Heat balance for effect 1
Tr2[i]=T2[i];
Hp2[i]=0; // since the reference temperature and the product temperature are same
Hv2[i]=Lv2[i];
(((Wf-Wv1[i])*(Cpf*(T1[i]-Tr2[i])))+(Wv1[i]*Lv1[i]))=((Wv2[i])*Hv2[i]);
(Wv1[i]+Wv2[i])=Wv_T;
A1[i]=((S[i]*Ls)/(U1*delT1[i]));
A2[i]=((Wv1[i]*Lv1[i])/(U2*delT2[i]));
end for;
A=(A1[2]+A2[2])/2;
//Steam economy 
SE=((Wv1[2]+Wv2[2])/(S[2]));
//Due to there is approximation in the book calculation, there is a slight variation in the simulated result with the book ans
end Ex9_4;
