model Ex9_5
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Saturated steam at a pressure of 3.32 bar absolute is fed to the steam chest of the first effect of a multiple effect evaporator. The residual pressure in the condenser attached to the last effect is 0.195 bar. If the sum of the temperature losses because of BEP is 41 K, determine the maximum number of effects to be used. The available temperature driving force in an effect must be at least 8 K.</body></html>"));
//Data are taken from the steam table
parameter Real Ts(unit="K")=410"Temperature of saturated steam";
parameter Real Tp_N(unit="K")=333"Temperature at last effect";
parameter Real BPE(unit="K")=41"Boiling point elevation";
parameter Real delTa_1(unit="K")=8"Available temperature difference in each effect";
Real delT_T(unit="K")"Total temperature difference";
Real delTa(unit="K")"Available temperature drop across the unit";
Integer Nmax"maximum Number of effects";
equation 
delT_T=(Ts-Tp_N);
delTa=(delT_T-BPE);
Nmax=(delTa/delTa_1);
end Ex9_5;
