model Ex11_2
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Air at 30C flow over a flat surface at a velocity of 8 m/s. The temperature of the surface is 200 C. Calculate the thermal boundary layer thickness and the local heat transfer coefficient 0.75 m from the leading edge.</body></html>"));
// Data are given in problem statement
parameter Real ki_vis(unit="m^2/s")=2.5*10^(-5)"Kinamatic viscosity";
parameter Real Pr=0.69"Prandtl Number of air";
parameter Real k(unit="W/m C")=0.036"Thermal conductivity of air";
parameter Real Ta(unit="C")=30"Air temperature";
parameter Real Ts(unit="C")=200"Surface temperature";
parameter Real x(unit="m")=0.75"Given distance";
parameter Real v(unit="m/s")=8"Velocity of air";
Real Tf(unit="C")"Mean temperature";
Real delta_T(unit="mm")"Thermal boundary layer thickness";
Real Rex"Local reynolds number at x";
Real Nux"Local Nusselt Number at x";
Real hx(unit="W/m^2 C")"Local Heat transfer coefficient";
equation
Tf=((Ta+Ts)/2);
Rex=((x*v)/(ki_vis));
(delta_T/1000)=(5*(x/(Rex^(1/2)))*(Pr^(-1/3)));
//Local heat transfer coefficient
Nux=(0.332*(Rex^(1/2))*(Pr^(1/3)));
Nux=(hx*x/k);
end Ex11_2;
