model Ex11_3
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A thin metal plate separates two air streams flowing on either side of it at zero angle of incidence. Free steam velocity is 6 m/s and the temperature of the air on one side of the plate is 150 C, and the corresponding value on the other side are 3 m/s and 50 C. Calculate the local rate of heat exchange between the two air streams and also the plate temperature at a distance 0.7 m from the leading edge. Assume the boundary layer to be laminar. Axial conduction in the plate may be neglected.</body></html>"));
parameter Real T1(unit="C")=150"Temperature of air at one side";
parameter Real T2(unit="C")=50"Temperature of air at other side";
parameter Real x(unit="m")=0.7"Given point";
parameter Real ki_vis_1(unit="m^2/s")=2.6*10^(-5)"Kinamatic viscosity of air at side 1";
parameter Real Pr_1=0.69"Prandtl Number of air at side 1";
parameter Real k_1(unit="W/m C")=0.0336"Thermal conductivity of side 1";
parameter Real v_1(unit="m/s")=6"Velocity of air at side 1";
parameter Real ki_vis_2(unit="m^2/s")=2.076*10^(-5)"Kinamatic viscosity of air at side 2";
parameter Real Pr_2=0.7"Prandtl Number of air at side 2";
parameter Real k_2(unit="W/m C")=0.03"Thermal conductivity of side 2";
parameter Real v_2(unit="m/s")=3"Velocity of air at side 2";
Real Ts(unit="C")"Assumed Temperature of plate";
Real Ta1(unit="C")"Mean temperature of air side 1";
Real Ta2(unit="C")"Mean temperature of air side 2";
Real Rex1"Local reynolds number at side 1";
Real Rex2"Local reynolds number at side 2";
Real Nux1"Local Nusselts Number at side 1";
Real Nux2"Local Nusselts Number at side 2";
Real hx1(unit="W/m^2 C")"Local HTC at side 1";
Real hx2(unit="W/m^2 C")"Local HTC at side 2";
Real U(unit="W/m^2 C")"Local Overall heat transfer coefficient";
Real Q(unit="W/m^2")"Local heat transfer rate";
Real Ts_c(unit="C")"Calculated Plat temepature";
equation
Ts=((T1+T2)/2);
//At side 1
Ta1=((Ts+T1)/2);
Rex1=(x*v_1/ki_vis_1);
Nux1=(0.332*(Rex1^(1/2))*(Pr_1^(1/3)));
Nux1=(hx1*x/k_1);
//At side 2
Ta2=((Ts+T2)/2);
Rex2=(x*v_2/ki_vis_2);
Nux2=(0.332*(Rex2^(1/2))*(Pr_2^(1/3)));
Nux2=(hx2*x/k_2);
//Local Overall heat transfer coefficient
U=(1/((1/hx1)+(1/hx2)));
Q=(U*(T1-T2));
Q=(hx2*(Ts_c-T2));
//The calculated plate temperature and assumed plate temperature are very close to each others. So there is no need of further calculation
//Due to the approximation in the book calculation, there is a slight difference in the simulated results with the book ans
end Ex11_3;
