model Ex2_3
  annotation(
    Documentation(info = "<html><head></head><body>A cylindrical hot duct, 0.5 m inside radius, has an inner layer of fireclay brick (k=1.3 W/m c) of 0.27 m thickness. The outer layer, 0.14 m thick is made of a special brick (k=0.92 W/m C). The brickwork is enclosed by an outer steel cover which has a temperature of 65 C. The inside tempertaure of the composite cylinderical wall of the duct is 400 C.Neglect the thermal resistance of the steel cover, calculate the rate of heat loss per metre of the duct and also the interface temperature between the ceramic layers. What fraction of the tatal resistance is offered by special brick layer?</body></html>"));
//Problem statements is given in the Documentation view
  final constant Real pi = 2 * Modelica.Math.asin(1.0);
  Real R1(unit = "C/W") "Resistance to heat transfer by fireclay";
  Real R2(unit = "C/W") "Resistance to heat transfer by Brick";
  Real ro(unit = "m") "Outer radius";
  Real r1(unit = "m") "Intermediate radius";
  Real Q(unit = "W") "Heat loss Rate";
  Real T1(unit = "C") "Intermediate Temperature";
  Real p "Fraction of the resistance by special brick";
  parameter Real ri(unit = "m") = 0.5 "Inner radius";
  parameter Real t1(unit = "m") = 0.27 "Thickness of Fireclay";
  parameter Real t2(unit = "m") = 0.14 "Thickness of brick";
  parameter Real K1(unit = "W/m K") = 1.3 "Thermal Conductivity of fireclay";
  parameter Real K2(unit = "W/m C") = 0.92 "Thermal conductivity of brick";
  parameter Real Ti(unit = "C") = 400 "Inside Temperature";
  parameter Real To(unit = "C") = 65 "Outer Temperature";
equation
  r1 = ri + t1;
  ro = r1 + t2;
  R1 = log(r1 / ri) / (2 * pi * K1);
  R2 = log(ro / r1) / (2 * pi * K2);
  Q = (Ti - To) / (R1 + R2);
  Q = (Ti - T1) / R1;
  p = R2 / (R1 + R2);
   //There may be a chance of slight changes in the ans from book due to the approximation in the book ans
end Ex2_3;
