model Ex2_5
  annotation(
    Documentation(info = "<html><head></head><body>Polyurethene foam and expanded polystyrene are two important insulation for low temperature appications. Polyurethene can be impregnated with a flme retardant and is probably safer. It is desired to calculate the heat gain by a Horton sphere (a Spherical vessel an for cryogenic sorage) of 16 m diameter that contains liquid ammonia at 4 C. The tank is insulated with a 10 cm thick layer of polyurethene foam having a thermal conductivity of 0.02 W/m C (0.0115 Btu/h ft2 F). The outer surface temperature of the insulations 27 C. Also calculate the refrigeration requirement of the vessel.</body></html>"));
//Problem statements is given in the Documentation view
  final constant Real pi = 2 * Modelica.Math.asin(1.0);
  Real Q(unit = "W") "Heat loss rate";
  Real TON(unit = "Ton") "Tonnes of refrigerent";
  Real ro(unit = "m") "Outer radius of the insulation";
  Real ri(unit = "m") "Inner radius of the insulation";
  parameter Real K(unit = "W/m C") = 0.02 "Thermal conductivity of polyurethene";
  parameter Real Ti(unit = "C") = 4 "Inside temperature";
  parameter Real To(unit = "C") = 27 "Outer temperature";
  parameter Real t(unit = "m") = 0.1 "Thickness of the insulation";
  parameter Real di(unit = "m") = 16 "Inner diameter of the Insultion";
equation
  ro = ri + t;
  ri = di / 2;
  Q = 4 * pi * K * (Ti - To) / (1 / ri - 1 / ro);
// 1 ton of refrigerent=12000 Btu=3.516 W
  TON = abs(Q) / (3.516 * 1000);
  //There may be a chance of slight changes in the ans from book due to the approximation in the book ans
end Ex2_5;
