model Ex3_11
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Pre-stressed multi-layered shell are often used for high pressure service (the urea reactor is a typical example) because of a smaller wall thickness required compared to a single-layer shell to withstand the same internal pressure. Such shell are often made by 'shrink fitting'. As such there is a possibility of existence of a thermal contact resistance at the interface between the two layer because of the entrapped gases in the crevices on the metal surfaces.<div>&nbsp; &nbsp; &nbsp; A two-layered cylindrical shell of high tensile steel (Cr-Mo-V) has an i.d. of 90 cm, and an 0.d. of 110 cm. The layer are equal in thickness. Under steady operating conditions, the inside temperature of the shell is 180 C and that of the outer surface is 170 C, making a temperature drop of 10 C across the composite wall. The thermal conductivity of alloy is 37 W/m C, and &nbsp;the rate of heat loss through the wall is known to be 5.18 KW per metre length of the shell.</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>(a) Is there any thermal contact resistance at the interface between the layer?</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>(b) If so, calculate the resistance based on one metre length of the shell and also express it in terms of a contact heat transfer coefficient.</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>(c)Calculate the temperature Jump across the contact surface.</div></body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real ri(unit="m")=0.45"Inner radius of shell";
parameter Real r1(unit="m")=0.5"Boundary between layers";
parameter Real ro(unit="m")=0.55"Outer radius of the shell";
parameter Real k(unit="W/m C")=37"Thermal conductivity of alloy";
parameter Real L(unit="m")=1"Length of the shell";
parameter Real Ti(unit="C")=180"Inside wall temperature";
parameter Real To(unit="C")=170"Outside wall temperature";
parameter Real Q(unit="C")=5180"Heat loss rate with contact resistance";
Real Q1(unit="W")"Heat transfer rate without contact resistance";
Real R1(unit="C/W")"Resistance of inner layer";
Real R2(unit="C/W")"Resistance of the outer layer";
Real Rc(unit="C/W")"Contact Resistance";
Real hc(unit="W/m^2 K")"Contact heat transfer coefficient";
Real As(unit="m^2")"Contact Surface Area";
Real T_jump(unit="C")"Jump in temperature";
equation
//Subdivision (a)
Q1=((2*pi*L*k)*(Ti-To)/(log(ro/ri)));
//there is a contact resistance available, since Q<Q1
//Subdivision (b)
R1=((log(r1/ri))/(2*pi*L*k));
R2=((log(ro/r1))/(2*pi*L*k));
Q=((Ti-To)/(R1+R2+Rc));
As=(2*pi*r1*L);
hc=(1/((As)*Rc));
//Subdivision (C)
Q=(hc*As*T_jump);
end Ex3_11;
