model Ex3_14
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A schedule 40 6-inch carries saturated steam at an absolute pressure of 8.2 bar. Calculate the optimum thickness of the bonded rockwool insulation for the steam pipe line. The following data are given<div>&nbsp;Saturati on tempertaure of steam ta 8.2 bar (absolute) is 172 C</div><div>&nbsp;Ambient temperature=20 C</div><div>&nbsp;Cost of steam =Rs 700 per ton</div><div>&nbsp;Latent heat of condensation of the steam at 172C=487 Kcal/Kg</div><div>Outer surface heat transfer coefficient =10.32 Kcal/h m^2 C</div><div>&nbsp;Thermal conductivity of the insulation=0.031 Kcal/h m C</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>Insulation cost (Including the cost of insulation, Cladding, labour and supervision) is a function of the insulation diameter, C'=(17,360-1.91*10^(4)*di) Rs/m^3, Over the range, 0.114&lt;di&lt;0.406, Where di (in meter) is the inner diameter of the insulation (or the o.d. of the pipe)</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>service life of insulation is 5 years</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>Interest rate=0.18 Re/(yr Re)</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>The exact outer diameter of a schedule 40 6-inch n.b. (nominal bore) pipe is 0.168 m.</div></body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real di(unit="m")=0.168"Outer diameter of pipe";
parameter Real Cs(unit="Rs/ton")=700"Cost of steam";
parameter Real Ls(unit="Kcal/Kg")=487"Latent heat of steam";
parameter Real interest(unit="Re/(yr Re)")=0.18"Interest rate";
parameter Real n(unit="Years")=5"Insulation life";
parameter Real Kc(unit="Kcal/h m C")=0.031"Thermal conductivity of insulation";
parameter Real ho(unit="Kcal/h m^2 C")=10.32"Outer heat transfer coefficient";
parameter Real Ti(unit="C")=172"Temperature of steam";
parameter Real To(unit="C")=20"Ambient temperature";
parameter Real ri(unit="m")=0.084"Inner radius of insulation";
Real Ci(unit="Rs/m^3")"Cost of insulation";
Real Ch(unit="Rs/Kcal")"Cost of heat energy";
Real[6] sum"Temporary variable";
Real ro(unit="m")"Optimum outer radius of insulation";
Real t(unit="m")"Optimal Insulation thickness";
equation
Ci=(17360-(1.91*(10^(4))*di));
Ch=(Cs/(1000*Ls));
sum[1]=0;
for i in 1:5 loop
sum[i+1]=(sum[i]+((1+interest)^(-i)));
end for;
//Finding out the optimal radius
((((-sum[6])*(Ch)*(2*pi)*(ri)*(Kc/ri)*((7200)*(Ti-To))*((1/ro)-((Kc/ho)/((ro^2)))))/(((log(ro))+((Kc/ho)/ro)-(log(ri)))^2))+(2*Ci*pi*ro))=0;
t=(ro-ri);
//In book there is a mistake in the calculation of insulation cost,so there is a difference in the simulated result with book ans
end Ex3_14;
