model Ex3_9
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A heat generation slab A(Thickness=0.25 m,Ka=15 W/m C) is sand wiched between two other slabs B (Thickness=0.1 m, KB=10 W/m C) and C (thckness=0.15m, Kc=30 W/m C) as shown in fig.(refer pg.no(72)) There is no heat generation in slab B or C. The temperature distribution in slab A is known to be Ta=900+4500x-11000x^2, where T is in C and x is the distance (in metres) from the left surface of B as shown in the fiure. The wall B is in contact with a fluid at temerature T1=40 C, The wall heat transfer coefficient being h1, Similarly, The free surface of C loses heat to a medium at a temoerature 35 C, and the surface ehat transfer coefficient is h2. Assume steady state condition.<div><br></div><div>(a) Calculate the temperature at the surface of slab A. What is the maximum temperature in A and where does it occur?</div><div>(b)Determine the temperature gradient at both the surface of each of the slab A,B ans=d C. COmment on the signs of the gradients.</div><div>(c)Find the temperature profiles in slabs B and C. Also, calculate the value of the heat transfer coefficient h1 and h2.</div></body></html>"));
parameter Real Xa1(unit="m")=0.1"Left Surface location of A";
parameter Real Xa2(unit="m")=0.35"Right surface location of A";
parameter Real Ka(unit="W/m C")=15"Thermal conductivity of A";
parameter Real Kb(unit="W/m C")=10"Thermal conductivity of C";
parameter Real Kc(unit="W/m C")=30"Thermal conductivity of C";
parameter Real T1(unit="C")=40"Temperature of contact fluid at left end";
parameter Real T2(unit="C")=35"Temperature of contact fluid at Right end";
parameter Real xa(unit="m")=0.25"Thickness of slab a";
parameter Real xb(unit="m")=0.1"Thickness of slab b";
parameter Real xc(unit="m")=0.15"Thickness of slab c";
Real Ta1(unit="C")"Left surface temperature of A";
Real Ta2(unit="C")"Risht surface temperature of A";
Real Ta_max(unit="C")"Maximum temperature of A";
Real Xa_max(unit="C")"Location of maximum Temperature of A";
Real dTdx_A_L(unit="C/m")"Temeperature gradient at left end of A";
Real dTdx_A_R(unit="C/m")"Temeperature gradient at Right end of A";
Real dTdx_B_L(unit="C/m")"Temeperature gradient at left end of B";
Real dTdx_B_R(unit="C/m")"Temeperature gradient at Right end of B";
Real dTdx_C_L(unit="C/m")"Temeperature gradient at left end of C";
Real dTdx_C_R(unit="C/m")"Temeperature gradient at Right end of C";
Real h1(unit="W/m^2 C")"Heat transfer coefficient at left end";
Real h2(unit="W/m^2 C")"Heat transfer coefficient at Right end";
Real Tb_L(unit="W/m^2 C")"Temperature of left end of B";
Real Tc_R(unit="W/m^2 C")"Temperature of right end of C";
equation
//Subdivision (a)
Ta1=(90+(4500*Xa1)-(11000*(Xa1^2)));
Ta2=(90+(4500*Xa2)-(11000*(Xa2^2)));
(4500-(2*11000*Xa_max))=0;
Ta_max=(90+(4500*Xa_max)-(11000*(Xa_max^2)));
//Subdivision (b)
dTdx_A_L=(4500-(2*11000*Xa1));
dTdx_A_R=(4500-(2*11000*Xa2));
(Kb*(dTdx_B_R))=(Ka*(dTdx_A_L));
dTdx_B_L=dTdx_B_R;
(Kc*(dTdx_C_L))=(Ka*(dTdx_A_R));
dTdx_C_R=dTdx_C_L;
//Subdivision (c)
//Temperature profile of C is Tc=877.5-1600x
//Temperature profile of B id Tb=3450x+85
h1*(T1-Tb_L)=(-Kb*dTdx_B_L);
h2*(Tc_R-T2)=(-Kc*dTdx_C_R);
Tb_L=(3450*(0)+85);
Tc_R=877.5-1600*(xa+xb+xc);
end Ex3_9;
