model Ex6_4
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A mixture of benzene and toluene, taken a cut from a reformate distilation column in a refinery, has to be separated further in another distilation column. A reboiler is required to partially boil out the bottom liquid of the column. The vapour generated flows up through the column. The bottom liquid contains a little benzene, but for the purpose of heat transfer calculations the physical properties of the liquid can be assumed to be the same as those of toluene. So far as the boiling calculations are concerned, we formulate the problem as follows.<div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>Toluene,a s a saturated liquid, enters the bottom of a 14 BWG 25 mm vertical tube at 0.3 bar gauge pressure at the rate of 200 kg/h, 30 % of which is vaporized per pass. The tube wll temperature is maintained at 160 C(433 K) by saturated steam condensing outside the tube at 4.7 bar(gauge). It is desired to calculate the required length of the tube.</div></body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
//data are given in the problem statement
parameter Real Tsat(unit="C")=120"boiling point of Toluene";
parameter Real Tw(unit="C")=160"Tube wall temperature";
parameter Real Lv(unit="j/Kg")=3.63*10^5"Latend heat of vaporization";
parameter Real k(unit="W/m C")=0.112"Thermal conductivity of liquid";
parameter Real Cp(unit="J/kg C")=1968"Specific heat capacity of liquid";
parameter Real density(unit="Kg/m^3")=753"Density of liquid";
parameter Real sur_ten(unit="N/m")=1.66*10^(-2)"Surface tensio of the liquid";
parameter Real viscosity(unit="Kg/m S")=2.31*10^(-4)"Viscosity of liquid";
parameter Real ro_v(unit="kg/m^3")=3.7"Density of vapour";
parameter Real vis_v(unit="Kg/m S")=10^(-5)"Viscosity of vapour";
parameter Real d(unit="m")=0.0211"inner Diameter of tube";
parameter Real m(unit="Kg/h")=200"mass flow rate";
parameter Real w=0.125"Mean vapour mass fraction";
Real G(unit="Kg/m^2 S")"Mass flux";
Real Re"Reynolds Number";
Real Pr"Prandtl Number";
Real one_by_x"correlation decision factor";
Real F"Factor";
Real hc(unit="W/m^2 C")"H.T.C for forced convection";
Real hb(unit="W/m^2 C")"Boiling H.T.C";
Real delP(unit="N/m^2")"Vapour pressure difference between saturated and supersaturated liquid";
Real Te(unit="C")"Excess saturation temperature";
Real S"Boiling suppression factor";
Real h(unit="W/m^2 C")"Total Heat transfer coefficient";
Real mv(unit="kg/s")"Rate of vaporization";
Real Q(unit="W")"Heat transfer rate";
Real A(unit="m^2")"heat trasnfer area";
Real l(unit="cm")"length of the tube";
equation
Te=(Tw-Tsat);
G=(m/(3600*((pi/4)*d^2)));
Re=((G*(1-w)*d)/viscosity);
Pr=((Cp*viscosity)/k);
one_by_x=(((w/(1-w))^0.9)*((density/ro_v)^0.5)*(vis_v/viscosity)^0.1);
//according to the value of 1/x the following correlation is used for cal calculatio id factor F
F=2.35*(one_by_x+0.231)^(0.736);
hc=0.023*(Re^0.8)*(Pr^0.4)*(k/d)*F;
delP=((Te*Lv)/((Tsat+273)*((1/ro_v)-(1/density))));
hb=((1.218*10^(-3))*((((k^0.79)*(Cp^0.45)*(density^0.49))/((sur_ten^0.5)*(viscosity^0.29)*(Lv^0.24)*(ro_v^0.24)))*(Te^0.24)*(delP^0.75)*S));
S=(1+(0.12*((10^(-4))*(Re)*(F^1.25))^1.14))^(-1.0);
h=hc+hb;
//5% is reduced in 1 hr
mv=(m/3600)*0.05;
Q=mv*Lv;
Q=h*A*(Tw-Tsat);
A=pi*d*(l*(10^(-2)));
end Ex6_4;
