model Ex6_7
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Saturaed vapour of benzene at 1 atm pressure enters a horizontal 16 BWG 3/4 inch tube(o.d=19 mm,id=16 mm) at a mass velocity of 20 Kg/m^2 S. A coolant flows outside the tube and teh wall temperature is maintained at 55 C. What fraction of vapour will condense if the tube si 0.5 m long?&nbsp;</body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
//Data are given in the problem statement
parameter Real density(unit="Kg/m^3")=815"Density of benzene";
parameter Real viscosity(unit="Kg/m S")=3.81*10^(-4)"Viscosity of benzene";
parameter Real Cp(unit="KJ/kg C")=1.94"Specific heat capacity of benzene";
parameter Real k(unit="W/m C")=0.13"Thermal conductivity of benzene";
parameter Real Lv(unit="KJ/kg")=391"Latent heat of vaporization";
parameter Real Tv(unit="C")=80"Normal Boiling point";
parameter Real Tw(unit="C")=55"Tube wall temperature";
parameter Real ro_v(unit="Kg/m^3")=2.7"Density of vapour";
parameter Real id(unit="m")=0.016"Inner diameter of tube";
parameter Real od(unit="m")=0.019"Outer diameter of tube";
parameter Real L(unit="m")=0.5"Length of the tube";
parameter Real g(unit="m/s^2")=9.8"Gravitational acceleration";
parameter Real G(unit="Kg/m^2 s")=20"Mass velocity of benzene vapour";
Real Lv1(unit="KJ/Kg")"Modified latent heat of vaporization";
Real h(unit="W/m^2 C")"Heat transfer coefficient";
Real A(unit="m^2")"Heat transfer Area";
Real Q(unit="W")"Heat transfer Rate";
Real m(unit="Kg/h")"Rate of condensation";
Real f(unit="%")"Fraction of vapor condensed";
equation
Lv1=(Lv+((3/8)*Cp*(Tv-Tw)));
h=(0.555*(((g*density*(density-ro_v)*(k^3)*(Lv1*1000))/(id*viscosity*(Tv-Tw)))^(1/4)));
A=(pi*id*L);
Q=(h*A*(Tv-Tw));
(m/3600)=(Q/(Lv1*1000));
f=((m/3600)/(G*(pi/4)*(id^2)))*100;
//Due to the approximation in the book, there is a slight variation in the simulated results with the book answer
end Ex6_7;
