model Ex7_12
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A corbon steel shere, 0.3 m in diameter and at 800 K, cools down by radiative heat loss to an ambient at 30 C. If other modes of heat loss are neglected, and if the ball and the ambient are assumed to be abck, calculate the time required for the ball to cool down to 70 C. The density and specific heat of carbon steel are 7801 kg/m^3 and 0.473 KJ/KG C, respectively.</body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0); 
parameter Real F12=1"View factor 1-2";
parameter Real R(unit="m")=0.15"Radius of the sphere";
parameter Real density(unit="Kg/m^3")=7801"Density of carbon steel";
parameter Real Cp(unit="KJ/Kg C")=0.473"Specific heat of carbon steel";
parameter Real T2(unit="K")=303"Ambient air temperature";
parameter Real T1in(unit="K")=800"Initial temperature of sphere";
parameter Real SB(unit="W/m^2 K^4")=5.669*10^(-8)"Stefan boltzmann constant";
parameter Real dT(unit="k")=1"Step size";
Real A1(unit="m^2")"Area of the sphere";
Real m(unit="Kg")"Mass of the sphere";
Real t_70(unit="h")"Time required for sphere to reach 70 C ";
Real[458] T1(unit="K")"Temperature of sphere at any time t";
Real[458] t(unit="s")"Time of heat transfer";
equation
A1=(4*pi*(R^2));
m=((4/3)*(pi*(R^3)*density));
//The time required to bring down the temperature of sphere is obtained by backward difference method
// Initial condition
t[1]=0;
T1[1]=T1in;
for i in 1:457 loop
t[i+1]=(((m*(Cp*1000))/(A1*F12*SB*((T1[i+1]^4)-(T2^4))))*dT)+t[i];
T1[i+1]=T1[i]-dT;
end for;
t_70=(t[458]/3600);
end Ex7_12;
