model Ex7_14
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>COnsider an enclosure formed by two diffuse gray sherical surfaces. The outer radius of inner shpere is r1, and the inner radius of the outer shere is r2. The emissivity of the surfaces are E1 and E2 and the temperatures are T1 and T2.<div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>(a)Determine&nbsp;</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">		</span>(i)The view factor F12 and F21</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">		</span>(ii) The net rate of radiant enrgy gain by the inner surface.</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>(b) Henc calculate the rate of loss of saturated liquid nitrogen at 1 atm pressure stored in a double walled spherical Dewar flask.</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>The following data are given: r1=15 cm, r2=15.5 cm, E1=E2=0.06, temperature of the outer wall =25 C, normal boiling point of nitrogen=-196 C, heat of vaporization of nitrogen at its normal boiling point=200 KJ/Kg. Convection in the annular space may be neglected.&nbsp;</div></body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0); 
parameter Real F12=1"View factor 1-2";
parameter Real r1(unit="m")=0.15"Radius of inner cylinder";
parameter Real r2(unit="m")=0.155"Radius of outer cylinder";
parameter Real T1(unit="K")=77"Temperature of inner sphere";
parameter Real T2(unit="K")=298"Temperature of outer sphere";
parameter Real r1(unit="m")=0.15"Radius of inner radius";
parameter Real r2(unit="m")=0.155"Radius of outer radius";
parameter Real E1=0.06"Emisivity of inner sphere";
parameter Real E2=0.06"Emisivity of Outer sphere";
parameter Real SB(unit="W/m^2 K^4")=5.669*10^(-8)"Stefan boltzmann constant";
parameter Real hv(unit="KJ/kg")=200"Heat of vaporization of vapour";
Real F21"View factor 2-1";
Real A1(unit="m^2")"Area of inner sphere";
Real A2(unit="m^2")"Area of outer sphere";
Real Q1_net(unit="J/s")"Net rate of radiant energy gain by inner surface";
Real Nn2(unit="g/h")"Rate of nitrogen loss";
equation
//subdivision (a)(i)
A1=(4*pi*(r1^2));
A2=(4*pi*(r2^2));
F21=((A1)/(A2))*F12;
//Subdivision (a)(ii)
Q1_net=-((SB*((T1^4)-(T2^4)))/(((1-E1)/(E1*A1))+(1/(A1*F12))+((1-E2)/(E2*A2))));
//Subdivision (b)
(Nn2/3600)=(Q1_net/hv);
end Ex7_14;
