model Ex7_20
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Carbon dioxide gas taken in a test cell at 300 K and 1 atm pressure is found to absorb 91% of incident monochromatic radiation at lamda=4.2 micro meter. The path length is 10 cm. Calculate the spectral extinction coefficient a<sub>lamda</sub>.</body></html>"));
final constant Real e=Modelica.Math.exp(1.0);
parameter Real L(unit="m")=0.1"path length";
parameter Real T(unit="K")=300"Temperature of co2 gas";
parameter Real f_a=0.91"Fraction of radiation absorbed";
Real f_t"Traction of radiation transmitted";
Real a_lamda(unit="m^-1")"Spectral extinction coefficent";
equation
f_t=(1-f_a);
(e^((-a_lamda)*(L)))=f_t;
//there is an approximation error with the simulated result and the book ans
end Ex7_20;
