model Ex8_2
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Ethyl benzene is manufactured by alkylation of benzene with ethylene. The rection products are separated in a series of distillation column. Ethylbenzene is obtained as the distillate from the last column (Called the ethylbenzene column).<div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>In a 50 tpd ethylbenzene plant, The final product leaves the overhead condenser at 135 C. This is required to be cooled to 40 C before pumping it to the storage tank.</div><div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>Cooling water is available at 30 C for cooling. Design a shell and tube heat exchanger for this purpose. The allowable pressure drop is 0.15 Kg/cm^2 on both tube and shell sides.</div></body></html>"));
 final constant Real pi=2*Modelica.Math.asin(1.0);
//Data are given in the problem statement 
//some values are assumed
parameter Real ro_e(unit="Kg/m^3")=840"Density of ethylbenzene";
parameter Real Cp_e(unit="KJ/Kg k")=2.093"Specific Heat capacity of ethylbenzene";
parameter Real Tei(unit="C")=135"Inlet temperature of ethylbenzene";
parameter Real Teo(unit="C")=40"Outlet temperature of ethylbenzene";
//Properties of water at 35 C
parameter Real ro_w(unit="Kg/m^3")=993"Density of water";
parameter Real vis_w(unit="Kg/m S")=8*10^(-4)"Viscosity of water";
parameter Real Cp_w(unit="Kcal/Kg K")=1"Specific heat of water";
parameter Real k_w(unit="Kcal/h m K")=0.536"Thermal conductivity of water";
parameter Real m_e(unit="tpd")=50"Capacity of heat exchanger";
parameter Real Twi(unit="C")=30"Water inlet temperature";
parameter Real Two(unit="C")=40"Outlet temperature of water";
parameter Real id(unit="m")=0.0157"Inner diameter of the tube";
parameter Real od(unit="m")=0.019"Outer diameter of tube";
parameter Real[2] L(unit="m")={3,4.5}"Length of the heat exchanger";
parameter Real N=4"Number of passes";
parameter Real[2] c(unit="m")={0.0064,0.0064}"Clearance between adjacent tubes";
parameter Real[2] B(unit="m")={0.15,0.10}"Baffle spacing";
parameter Real[2] Ds(unit="m")={0.254,0.254}"Diameter of shell";
parameter Real[2] p(unit="m")={0.0254,0.0254}"Tube pitch";
parameter Real[2] jH_t={85,83}"Tube side factor";
parameter Real[2] jH_s={32,48}"Shell side factor";
parameter Real[2] Rdo(unit="h m^2 C/Kcal")={0.21*10^(-3),0.21*10^(-3)}"Shell fouling factor";
parameter Real[2] Rdi(unit="h m^2 C/Kcal")={0.35*10^(-3),0.35*10^(-3)}"Tube fouling factor";
parameter Real Ft=0.8"LMTD correction factor";
parameter Real g(unit="m/s^2")=9.8"Gravitational acceleration";
//Constant values for Tube side pressure drop
parameter Real f_pt=0.0037"constant for Tube side pressure drop calculation";
parameter Real fy_pt=1"constant for Tube side pressure drop calculation";
//constants for Shell side pressure drop calculation
parameter Real f_s=0.052"Constant for shell side pressure drop calculation";
parameter Real fy_s=1"Constant for shell side pressure drop calculation";
Real[2] Udo_a(unit="Kcal/h m^2 C")"Assumed Overall outside HTC";
Real Tm(unit="K")"Mean temperature";
Real vis_e(unit="Kg/m S")"Viscosity of ethylbenzene";
Real k_e(unit="Kcal/h m C")"Thermal conductivity of ethylbenzene";
Real Q(unit="Kcal/h")"Heat transfer rate";
Real m_w(unit="Kg/h")"Water mass flow rate";
Real LMTD(unit="C")"Log mean temperature difference";
Real[2] A(unit="m^2")"Area required for heat transfer";
Real[2] Ao(unit="m^2")"Ouside area of single tube";
Integer[2] n"Number of tubes";
Real[2] v_w(unit="m/s")"Velosity of water";
Integer[2] n_p"Number of tubes per pass";
Real[2] hi(unit="Kcal/h m^2 C")"Tube side heat transfer coefficient";
Real[2] ho(unit="Kcal/h m^2 C")"shell side heat transfer coefficient";
Real[2] Re_t"Tube side Reynolds Number";
Real[2] Pr_t"Tube side Prandtl Number";
Real[2] Re_s"Shell side Reynolds Number";
Real[2] Pr_s"Shell side Prandtl Number";
Real DH_T(unit="m")"Equivalent diameter for triangular pitch";
Real DH_S(unit="m")"Equivalent diameter for square pitch";
Real[2] DH(unit="m")"Equivalent diameter";
Real[2] A_s(unit="m^2")"Shell side flow area";
Real[2] Gs(unit="Kg/m^2 h")"Mass velocity of shell side fluid";
Real[2] Udo(unit="Kcal/h m^2 C")"Outside Overall heat transfer coefficient";
Real tou_c"Factor for Finding out Ft";
Real R"Factor for finding out Ft";
Real A_F(unit="m^2")"Area required with fouling for heat transfer";
Real A_a(unit="m^2")"Actual HT area available";
Real P_e(unit="%")"Percentage of excess area";
Real Gt(unit="Kg/m^2 S")"Tube side mass velocity";
Real delP_t(unit="N/m^2")"Tube side pressure drop";
Real delP_r(unit="N/m^2")"Return loss";
Real del_TP_t(unit="N/m^2")"Tube side total pressure drop";
Integer Nb"Number of baffles";
Real delP_S(unit="N/m^2")"Shell side pressure drop";
equation
Tm=(((Tei+Teo)/2)+273);
log(vis_e/(10^(-3)))=(-6.106+(1353*(Tm^(-1)))+(5.112*(10^(-3))*Tm)-(4.552*(10^(-6))*(Tm^2)));
k_e=(0.2142-(3.44*(10^(-4))*Tm)+(1.947*(10^(-7))*(Tm^2)))*((3600)/(1000*4.175));
//Energy balance
Q=((m_e*1000/24)*(Cp_e/4.175)*(Tei-Teo));
m_w=(Q/(Cp_w*(Two-Twi)));
LMTD=(((Tei-Two)-(Teo-Twi))/(log((Tei-Two)/(Teo-Twi))));
//2 Iteration are done to findout Overall HTC
DH_T=((4*(((0.5*p[1])*(0.86*p[1]))-((pi/8)*(od^2))))/((pi/2)*od));
DH[1]=DH_T;
DH_S=((4*((p[2]^2)-((pi/4)*(od^2))))/(pi*od));
DH[2]=DH_S;
Udo_a[1]=350;
Udo_a[2]=Udo[1];
n[1]=(A[1]/Ao[1])+1;
n[2]=48;
for i in 1:2 loop
A[i]=(Q/(Udo_a[i]*LMTD));
Ao[i]=(pi*od*L[i]);
//water is flowing in tube side and ethylbenzene is flowing in shell side
//To get a acceptable velocity 1-4 pass heat excahger type is taken
//25% cut segmental baffles with 0.15 m baffle spacing is taken
n_p[i]=(n[i]/N);
v_w[i]=(((m_w/ro_w)/3600)/(n_p[i]*(pi/4)*(id^2)));
//Tube side heat transfer coefficient
Re_t[i]=(id*v_w[i]*ro_w/(vis_w));
Pr_t[i]=((Cp_w*(vis_w*3600))/(k_w));
hi[i]=((jH_t[i])*((k_w)/(id))*((Pr_t[i])^(1/3)));
//Shell side heat transfer coefficient
A_s[i]=((c[i]*B[i]*Ds[i])/(p[i]));
Gs[i]=((m_e*1000/24)/A_s[i]);
Re_s[i]=((DH[i]*(Gs[i]/3600))/vis_e);
Pr_s[i]=(((Cp_e/4.175)*(vis_e*3600))/(k_e));
ho[i]=((jH_s[i])*((k_e)/(DH[i]))*(Pr_s[i]^(1/3)));
Udo[i]=(1/((1/ho[i])+Rdo[i]+((od/id)*Rdi[i])+((od/id)*(1/hi[i]))));
end for;
// array contains value of first iteration in first element and value of second iteration in second iteration
//LMTD correction factor
tou_c=((Two-Twi)/(Tei-Twi));
R=((Tei-Teo)/(Two-Twi));
//with the value of tou_c and R the vale of Ftis taken as 0.8 from fig 8.10(a) from Heat transfer: Principles and applications by Binay K Dutta
//outer Heat transfer area required with fouling
A_F=(Q/(Udo[2]*Ft*LMTD));
//Percentage of excess area
A_a=(pi*od*L[2]*n[2]);
P_e=((A_a-A_F)/(A_F))*100;
//Tube side pressure drop calculation
Gt=((m_w)/(3600*(pi/4)*(id^2)*n_p[2]));
delP_t=((f_pt*(Gt^2)*L[2]*N)/(2*ro_w*id*fy_pt));
delP_r=((4*N*(v_w[2]^2)*ro_w)/(2));
del_TP_t=(delP_t+delP_r);
//Shell side pressure drop calculation
Nb=((L[2]/B[2])-1);
delP_S=((f_s*((Gs[2]/3600)^2)*Ds[2]*(Nb+1))/(2*ro_e*DH[2]*fy_s));
//Due to the approximation in the book ans, there is a slight variation in the simulated result with the book ans
end Ex8_2;
