model Ex8_4
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A batch polymerization reaction, 1500 mm in diameter nd 1800 mm high, has a limpet coil of 18 turns.The inner diameter of half-pipe is 52.5mm and the pitch of the coil is 79.5 mm. In each batch, 2200 kg of the monomer (density=850 kg/m^3; specific aheat=0.45Kcal/kg C; Thermal conductivity=0.15 kcal/h m C) at 25 C is changed to the reactor that has to be heated to 80 C before the initiator is added to start the polymerization. Heating is done by a thermic fluid available at 120 C (density=900 kg/m^3; specific heat=0.5 kcal/kg C; Thermal conductivity= 0.28 Kcal/h m C). The average viscosity of the heat transfer fluid may be taken as 4cP, and that of the monomer as 0.7 cP. The vessel is provided with a flat-blade turbine agitator (six blade, 0.5 m diameter) which rotates at 150 rpm. The volume of the charge is such that, the liquid surface remains nearly at the level of the top of the limpetted region. The height of the limpetted section =1464 mm. A fouling factor of 0.0002 h m^2 C/Kcal may be taken for both the vessel and the coil side. Calculate &nbsp;the time required to heat the change.</body></html>"));
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real p(unit="m")=0.0795"Pitch of the coil";
parameter Real id(unit="m")=0.0525"Inner diameter of half pipe";
parameter Real D(unit="m")=1.5"Diameter of vessel";
parameter Real H(unit="m")=1.8"Height of the vessel";
parameter Real l(unit="m")=1.464"Height of the limpetted section";
parameter Real rpm(unit="rpm")=150"Agitater speed";
parameter Real ro_h(unit="Kg/m^3")=850"Density of vessel side fluid";
parameter Real vis_h(unit="Kg/m S")=0.7*10^(-3)"Viscosity of vessel side fluid";
parameter Real Cp_h(unit="Kcal/kg C")=0.45"Specific heat of monomer";
parameter Real k_h(unit="Kcal/h m C")=0.15"Thermal conductivity of monomer";
parameter Real d(unit="m")=0.5"Diameter of agitator";
parameter Real v_c(unit="m/s")=1.5"Velocity of cold side fluid";
parameter Real ro_c(unit="K/m^3")=900"Density of cold side fluid";
parameter Real vis_c(unit="Kg/m S")=4*10^(-3)"Viscosity of cold side fluid";
parameter Real Cpc(unit="Kcal/kg C")=0.5"Specific heat of cold side fluid";
parameter Real k_c(unit="Kcal/h m C")=0.28"Thermal conductivity of cold side fluid";
parameter Real Rdi(unit="C m^2 h/kcal")=0.0002"Vessel side fouling";
parameter Real Rdc(unit="C m^2 h/Kcal")=0.0002"Cold side fouling";
parameter Real Wv(unit="Kg")=2200"Capacity of monomer";
parameter Real Tci(unit="C")=120"Inlet temperature of cold fluid";
parameter Real Tvi(unit="C")=25"Initial temperature of vessel";
parameter Real Tvf(unit="C")=80"Final temperature of vessel";
Real Ao(unit="m^2")"Outside area";
Real Ao_eff(unit="m^2")"Effective heat transfer area";
Real Ai(unit="m^2")"Inside heat transfer area of the vessel";
Real Re_h"vessel side Reynolds Number";
Real Pr_h"Prandtl Number at vessel side";
Real Nu_h"Nusselt Number at vessel side";
Real hi(unit="Kcal/h m^2 C")"Vessel side heat transfer coefficient";
Real Ac(unit="m^2")"Coil flow area";
Real Wc(unit="kg/h")"Mass flow rate of cold fluid";
Real Re_c"Cold side reynolds number";
Real Pr_c"Cold side prandtl number";
Real Nu_c"Cold side Nusselt Number";
Real hc(unit="Kcal/h m^2 C")"Cold side HTC";
Real DH(unit="m")"Hydraulic diameter";
Real Ui(unit="Kcal/h m^2 C")"Inside overall heat transfer coefficient";
Real beta;
Real t(unit="min")"Time required to heat the charge";
equation
Ao=(pi*D*l);
//60% of the unwetted area is added to the wetted area to find out the effective outside area
Ao_eff=(((id+(0.6*(p-id)))/(p))*Ao);
//since the thickness of wall is small the inner and outer heat transfer area are same
Ai=Ao;
//Vessel side heat transfer coefficient
Re_h=(((d^2)*(rpm/60)*ro_h)/vis_h);
Pr_h=(Cp_h*vis_h/(k_h/3600));
Nu_h=(0.74*(Re_h^0.67)*(Pr_h^0.33));
Nu_h=(hi*D/k_h);
//Cold side heat transfer coefficient
Ac=((pi/4)*(id^2));
Wc=(v_c*Ac*ro_h*3600);
DH=((4*(pi/8)*(id^2))/(id+((pi/2)*id)));
Re_c=(DH*v_c*ro_c/vis_c);
Pr_c=(Cpc*vis_c/(k_c/3600));
Nu_c=(0.021*(Re_c^0.85)*(Pr_c^0.4)*((DH/l)^0.1));
Nu_c=(hc*DH/(k_c));
//Overall heat trasnfer coefficient
Ui=(1/((1/hi)+((Ai/Ao_eff)*(1/hc))+Rdi+Rdc));
//FInding out the time
log((Tci-Tvi)/(Tci-Tvf))=(((Wc*Cpc)/(Wv*Cp_h))*(((beta-1)*(t/60))/(beta)));
//where
beta=(e^((Ui*Ai)/(Wc*Cpc)));
//due to the approximation in the book, there is small variation in the simulated result with the book ans
end Ex8_4;
