model Ex9_1
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>An aqueous solution of a high molecular weight solute is concentrated from 5% to 40% at a rate of 100 m^3/ day. The feed temperature is 25 C, and the concentrate product leaves at its boiling point. Calculate the rate at which heat must be supplied if the evaporation occurs at&nbsp;<div>(i) 1 atmosphere pressure</div><div>(ii) a vacuum of 650 mm hg.</div><div>What advantage of this operation under vacuum is apparent from the answer?</div></body></html>"));
//Data are given in the problem statement
//Entire calculation is done for a single day
parameter Real F(unit="m^3")=100"Feed volume";
parameter Real ro_f(unit="Kg/m^3")=1020"Density of feed";
parameter Real xf=0.05"mass fraction of solute in feed";
parameter Real xd=0.4"mass fraction of solute in product";
parameter Real Cpf(unit="KJ/Kg C")=4.1"Specific heat of feed";
parameter Real Cpp(unit="KJ/Kg C")=3.9"Specific heat of product";
parameter Real Tr(unit="C")=0"Reference temperature";
parameter Real Tf(unit="C")=25"Temperature of feed";
parameter Real Tp_1(unit="C")=100"Boiling point of solution at 1 atm";
parameter Real Hv_1(unit="KJ/Kg")=2680"Latent heat of vaporization at 100 C, 1 atm";
parameter Real Tp_v(unit="C")=53.5"Boiling point of solution at 650 mmhg vacuum";
parameter Real Hv_v(unit="KJ/Kg")=2604"Latent heat of vaporization at 650 mmhg vacuum";
Real Wf(unit="Kg")"mass of feed";
Real Ws(unit="Kg")"Mass of solute";
Real Wwf(unit="Kg")"Mass of water in the feed";
Real Wd(unit="Kg")"mass of Product";
Real Wwd(unit="Kg")"Mass of water in product";
Real Wv(unit="Kg")"Mass of water eveporated";
Real Hf(unit="KJ/Kg of solution")"Enthalpy of feed";
Real Hp_1(unit="KJ/Kg of solution")"Enthalpy of product at 1 atm";
Real qs_1(unit="KJ/day")"Rate of heat supply at 1 atm pressure";
Real Hp_v(unit="KJ/Kg of solution")"Enthalpy of product at 650 mmHg vacuum";
Real qs_v(unit="KJ/day")"Rate of heat supply at 650mmhg vacuum";
Real p_e(unit="%")"Pecentage reduction in heat supply";
equation
//Material balance
Wf=(F*ro_f);
Ws=(Wf*xf);
Wwf=Wf-Ws;
Ws=(Wd*xd);//Solute balance
Wwd=(Wd-Ws);
Wv=(Wwf-Wwd);//Water balance
//Energy balance
Hf=(Cpf*(Tf-Tr));
//(i) When evaporator is working at 1 atm pressure
Hp_1=(Cpp*(Tp_1-Tr));
((Wf*Hf)+qs_1)=((Wv*Hv_1)+(Wd*Hp_1));//Heat balance
//(ii) When evaporator is working at 650 mm vacuum
Hp_v=(Cpp*(Tp_v-Tf));
((Wf*Hf)+qs_v)=((Wv*Hv_v)+(Wd*Hp_v));//Heat balance
//Percentage reduction in heat supply when vacuum is applied
p_e=(((qs_1-qs_v)/(qs_1))*100);
//Due to the approximation there is slight variation in the simulated result with the book ans
end Ex9_1;
