model Ex9_8
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Consider Example 9.1 assme that saturated steam is available at 2.03 Kg/cm^2 absolute. Make a mechanical vapour recompression calculation for the problem, If the compression ratio is 2:1.</body></html>"));
//Data are given in the book
parameter Real Lv(unit="KJ/Kg")=2200"Latent heat of condensation";
parameter Real Q(unit="KJ/day")=2.337*10^(8)"Rate of heat supply";
parameter Real T(unit="C")=100"Operating temperature of evaporator at 1 atm";
parameter Real P1(unit="atm")=1"Operating pressure of eveporator";
parameter Real P2(unit="atm")=2"Pressure of vapour after isentropic compression";
parameter Real Hc(unit="KJ/Kg of vapour")=2800"Enthalpy of compressed vapour";
parameter Real T2(unit="C")=175.5"Temperature of compressed vapour"; //From Molier's chart
parameter Real Ts(unit="C")=121"Temperature of saturated steam at 2 atm";
parameter Real Hs(unit="KJ/Kg of steam")=2700"Latent heat of vaporization of steam";
parameter Real Hsw(unit="KJ/Kg")=419"Enthalpy of spraying water at 100C";
parameter Real Wv(unit="Kg/day")=8.925*10^(4)"Rate of vapour generation";
Real S(unit="Kg/day")"Steam supply rate";
Real T_SH(unit="C")"Degree of superheating in compressed vapour";
Real x(unit="Kg of water supplied/Kg of superheated steam")"Kg of water supplied per Kg of superheated steam";
Real S_T(unit="Kg of obtained steam/kg of superheated steam")"Total amount of steam obtained after desupersaturation per kg of superheated steam";
Real Wrv(unit="Kg/day")"rate of recompression steam generation";
Real M_S(unit="Kg/day")"Makeup steam required per day";
equation
S=(Q/Lv);
T_SH=(T2-Ts);
((x*Hsw)+(Hc))=((x+1)*(Hs));
S_T=(x+1);
Wrv=(Wv*S_T);
M_S=(S-Wrv);
//due to the approximation in the book there is slight variation in the simulated result with the book ans
end Ex9_8;
