model Ex1_23
parameter Real k0(unit="s^-1")=2.785*10^(6) "Pre-Exponential factor";
parameter Real k(unit="s^-1")=1.3*10^(-3)  "Rate constant";
parameter Real T(unit="K")=300 "Temperature";
Real R(unit="cal/molK")=1.987 "Gas constant";
parameter Real h(unit="erg.s")=6.62*10^(-27) "Planck's constant";
Real delS(unit="e.u") "Entropy of Activation";
Real delH(unit="cal/mol") "Enthaply of Activation";
equation
delS=(log10(k0)-log10((k*T)/h))*(R*2.303);
delH=-(log10(k)-log10(k0))*(2.303*R*T);
//The textbook answer is wrong for delS//
//The model gives the exact values for delS and delH//
end Ex1_23;
