model Ex2_26
parameter Real[4] t(unit="min")={10,15,20,25} "Time";
parameter Real[4] V0(unit="ml")={6.30,8.95,11.40,13.50} "Volume of oxygen evoloved";
parameter Real Vinfinity(unit="ml")=34.75 "Volume of oxgyen evoloved at time infinity";
Real [4]V(unit="ml") "Final volume";
Real [4]k(unit="min^-1") "Rate constant";
equation
for i in 1:4 loop
  V[i]=(Vinfinity-V0[i]);
  k[i]=(1/t[i])*log(Vinfinity/V[i]);
  //Since the values of k are fairly constant the reaction follows first order//
end for;
//The answers given in the book is wrong//
end Ex2_26;
