model Ex2_3
//Half life period for 1st order reaction=0.696/k//
parameter Real t1(unit="s")=2.5*10^3 "Half life period";
Real k(unit="s^(-1)") "Rate constant";
//time required to decrease the concentration of reactant to 1/4th of its original concentration//
parameter Real Ca0(unit="mol/lit")= 1 "Initial concentration of A";
parameter Real Ca(unit="mol/lit")= 0.25 "Concentration of A";
Real t(unit="s") "Time required to decrease the concentration of reactant to 0.25 to its original concentration";
equation 
k=0.693/t1;
t=(1/k)*(log(Ca0/Ca));
//The value of t differs from that of book value//
end Ex2_3;
