model Ex2_31
parameter Real k(unit="lit/(mol.sec)")=0.977 "Rate constant";
parameter Real T(unit="K")=1168 "Temperature";
parameter Real R(unit="lit.atm/mol.K")=0.08206 "Gas constant";
parameter Real P0(unit="atm")=1 "Pressure";
parameter Real t1(unit="sec")=1 "Time1";
parameter Real t2(unit="sec")=10 "Time2";
parameter Real t3(unit="sec")=600 "Time3";
Real XA1(unit="No units") "Amount Decomposed at t1";
Real XA2(unit="No units") "Amount Decomposed at t2";
Real XA3(unit="No units") "Amount Decomposed at t3";
Real Xa1(unit="No units") "%Decomposed at t1";
Real Xa2(unit="No units") "%Decomposed at t2";
Real Xa3(unit="No units") "%Decomposed at t3";
equation
//Derivation is given in the book//
//Final equation= XA/(1-XA)=k*Po*t/(R*T)
(XA1/(1-XA1))=(k*P0*t1/(R*T));
(XA2/(1-XA2))=(k*P0*t2/(R*T));
(XA3/(1-XA3))=(k*P0*t3/(R*T));
Xa1=XA1*100;
Xa2=XA2*100;
Xa3=XA3*100;
end Ex2_31;
