model Ex2_4
parameter Real[4] t(unit="min")={1,2,3,4} "Time";
parameter Real[4] CA(unit="mol/lit")={0.113,0.08,0.056,0.040} "Concentration of N2O5";
parameter Real Ca0(unit="mol/lit")=0.16 "Initial Concentration of N2O5";
Real[4] k(unit="min^-1") "Rate constant";
Real K(unit="min^-1") "Average Rate constant";
//N2O5 gives N204+0.5O2//
equation
for i in 1:4 loop
  k[i]=-(log(CA[i]/Ca0))/t[i];
end for;
//Since the values of k are nearly constant we can assume it to be 1st order//
K=sum(k)/4;
end Ex2_4;
