model Ex2_41
parameter Real Ca0(unit="mol/lit")=1 "Initial concentration";
parameter Real [2]XA(unit="No units")={0.80,0.90} "Percentage conversion";
parameter Real [2]t1(unit="min")={8,18} "Time";
Real [2]k1(unit="min^-1") "Rate constant for first order reaction";
Real [2]k2(unit="mol/lit.min") "Rate constant for second order reaction";
Real K(unit="mol/lit.min") "Average rate constant";
Real rate(unit="mol/lit.min") "Rate of reaction";
equation
//For first order reaction//
for i in 1:2 loop
  log(1/(1-XA[i]))=k1[i]*t1[i];
  //The values are not constant, hence the reaction does not order first order//
  XA[i]/(1-XA[i])=k2[i]*Ca0*t1[i];
  //Since the values are fairly constant the reaction follows second order//
end for;
K=sum(k2)/2;
rate=K;
//Rate is given by k2*Ca^2//
end Ex2_41;
