model Ex2_55
parameter Real[7] t(unit="min")={2,4,6,8,10,12,14} "Time";
parameter Real[7] p(unit="mmHg")={600,475,390,320,275,240,215} "Partial pressure";
parameter Real R(unit="lit.atm/mol.K")=0.08206 "Gas constant";
parameter Real P(unit="mmHg")=760 "Total pressure";
parameter Real T(unit="K")=273 "Temperature";
Real [7]Ca(unit="mol/lit") "Concentration of A";
Real Ca0(unit="mol/lit") "Initial concentration of A";
Real [7]k(unit="min^-1") "Rate constant";
Real K(unit="min^-1") " Average Rate constant";
Real rate(unit="mol/(lit*min)") "Rate equation";
//To find concentration in terms of partial pressure//
equation
Ca0=((P/P)/(R*T));
for i in 1:7 loop
Ca[i]=(p[i]/P)/(R*T);
end for;
//Assuming First order//
for i in 1:7 loop
k[i]=(log(Ca0/Ca[i]))/t[i];  
end for;
//Since values of K are fairly constant the reaction is first order//
K=sum(k)/7;
rate=K;
//Final rate is given by r=k*Ca//
//The final answer differs from that given in the book//
end Ex2_55;
