model Ex3_27
parameter Real k1(unit="lit/mol.min")=7 "Rate cosntant 1";
parameter Real k2(unit="lit/mol.min")=3 "Rate cosntant 2";
parameter Real V1(unit="lit")=2.5 "Mixed stream";
parameter Real XA(unit="No units")=0.75 "Conversion of B";
parameter Real A(unit="mol/lit")=2.8 "Feed stream containing A";
parameter Real B(unit="mol/lit")=1.6 "Feed stream containing B";
parameter Real V(unit="lit")=120 "Volume";
parameter Real a(unit="No units")=1 "Volume ratio of A";
parameter Real b(unit="No units")=1.5 "Volume ratio of B";
Real Ca0(unit="mol/lit") "Initial concentration of A";
Real Cb0(unit="mol/lit") "Initial concentration of B";
Real Breacted(unit="mol/lit") "B reacted";
Real Ca(unit="mol/lit") "Concentration of A";
Real Cb(unit="mol/lit") "Concentration of B";
Real Cr(unit="mol/lit") "Concentration of R";
Real ra(unit="mol/(lit.min)") "Rate of reaction";
Real v(unit="lit/min") "Volumetric flow rate";
Real va(unit="lit/min") "Volumetric flow rate of A";
Real vb(unit="lit/min") "Volumetric flow rate of B";
equation
Ca0=A/V1;
Cb0=B/V1;
Breacted=XA*Cb0;
Ca=Ca0-Breacted;
Cb=Cb0-Breacted;
Cr=Breacted;
//Cr=Cs//
ra=(k1*Ca*Cb)-(k2*Cr*Cr);
v=(V*ra)/(Ca0-Ca);
va=(a/V1)*v;
vb=(b/V1)*v;
end Ex3_27;
