model Ex3_35
parameter Real V(unit="lit")=2 "Volume of the reactor";
parameter Real v0(unit="lit/min")=4 "Volumetric flow rate";
parameter Real Ca0(unit="mol/lit")=1 "Initial concentration of A";
parameter Real Cw0(unit="mol/lit")=0 "Initial concentration of W";
parameter Real Ca(unit="mol/lit")=0.01 "Concentration of A in the leaving stream";
parameter Real Cw(unit="mol/lit")=0.002 "Concentration of W in the outlet stream";
Real RateA(unit="mol/(lit.min)") "Rate of reaction A";
Real RateW(unit="mol/(lit.min)") "Rate of reaction W";
equation
//For a mixed flow reactor//
-RateA=(Ca-Ca0)/(V/v0);
//For a particular product W being produced//
-RateW=(Cw0-Cw)/(V/v0);
//Since the negative sign cancels, W is being produced//
end Ex3_35;
