model Ex3_4
parameter Real XA(unit="No units")=0.90 "Conversion";
parameter Real S(unit="min^-1")=1 "Space velocity";
parameter Real b(unit="moles")=3 "Moles at complete conversion";
parameter Real a(unit="moles")=2 "Moles at no conversion";
parameter Real V(unit="Lit")=1 "Volume";
Real tow(unit="min") "Space time";
Real EA(unit="No units") "Fractional conversion";
Real Vf(unit="Lit") "Final volume";
Real t(unit="min") "Mean residence time";
equation
tow=1/S;
EA=(b-a)/a;
Vf=V*(1+(EA*XA));
t=(V/Vf);
end Ex3_4;
