model Ex3_48
//Basis 100 moles of feed//
parameter Real b(unit="mol")=110 "Moles of product";
parameter Real a(unit="mol")=100 "Moles of Reactant";
parameter Real k(unit="lit/(mol.sec)")=0.05 "Rate constant";
parameter Real xa(unit="No units")=0.20 "Mole fraction of A";
parameter Real P(unit="atm")=1.5 "Pressure";
parameter Real T(unit="K")=366 "Temperature";
parameter Real R(unit="atm.lit/mol.K")=0.08206 "Rate constant";
parameter Real v0(unit="lit/sec")=1 "Volumetric flow rate";
parameter Real XA(unit="No units")=0.5 "Conversion";
Real EA(unit="No units") "Fractional conversion";
Real Ca0(unit="mol/lit") "Initial concentration of A";
Real V(unit="lit") "Volume";
equation
EA=(b-a)/a;
Ca0=(P*xa)/(R*T);
(Ca0*k*V)=(2*EA*(1+EA)*log(1-XA)+((EA)^(2)*XA)+((EA+1)^(2)*(XA/(1-XA))))*v0;
//The answer given in the text book is wrong//
end Ex3_48;
