model Ex4_25
parameter Real Fc0(unit="kmol/day")=4000 "Production rate of ethylenne glycol";
parameter Real Ca01(unit="kmol/m^3")=16.05 "Concentration of A in ethylene oxide stream before mixing";
parameter Real XA(unit="No units")=0.80 "Conversion";
parameter Real k(unit="min^-1")=0.311 "Rate constant";
parameter Real V1(unit="lit")=3 "Volume of equal three sized CSTR";
Real Foi(unit="kmol/min") "Molar flow rate of A to each unit";
Real Fc(unit="kmol/min") "Production rate of ethylene glycol";
Real Fa0(unit="kmol/min") "Molar flow rate of ethylene oxide";
Real va0(unit="m^3/min") "Volumetric flow rate of stream A";
Real vb0(unit="m^3/min") "Volumetric flow rate of stream B";
Real v0(unit="m^3/min") "Total Volumetric flow rate";
Real X(unit="No units")"Conversion achieved in each reactor";
Real X1(unit="No units")"Conversion achieved in three CSTR reactors";
Real X2(unit="No units")"Conversion achieved in four CSTR reactors";
Real Ca0(unit="kmol/m^3") "Concentration of A";
Real V(unit="m^3") "Volume of reactor";
Real Tow(unit="min") "Space time";
Real Tow1(unit="min") "Space time1";
Real Tow2(unit="min") "Space time2";
equation
//For single CSTR//
Fc=Fc0/(24*60);
Fa0=Fc/XA;
va0=Fa0/Ca01;
vb0=va0;
Foi=Fa0/2;
Tow=V1/(Foi/Ca0);
X=(Tow*k)/(1+(Tow*k));
v0=vb0+va0;
Ca0=Fa0/v0;
V=Fa0*XA/(k*Ca0*(1-XA));
//For 3 CSTR in parallel//
Tow1=V1/(v0/3);
X1=(Tow1*k)/(1+(Tow1*k));
//For 4 CSTR in parallel//
Tow2=V1/(v0/4);
X2=(Tow2*k)/(1+(Tow2*k));
//Two CSTRs of volume 3 m^3 are connected in parallel for 0.81 conversion//
end Ex4_25;
