model Ex4_9
parameter Real tow(unit="sec")=96 "Space time";
parameter Real EA(unit="No units")=0 "Negligible expansion";
parameter Real C0(unit="mol/lit")=1 "Initial concentration";
parameter Real C1(unit="mol/lit")=0.5 "Concentration in first reactor";
parameter Real C2(unit="mol/lit")=0.25 "Final concentration";
Real tow2(unit="sec") "Space time of second reactor";
Real n(unit="No units") "Order of the reaction";
Real k(unit="lit/mol.sec") "Rate constant";
Real Rate(unit="mol/lit.sec") "Rate equation";
equation
tow2=(2*tow);
//Since volume of CSTR2 is two times the volume of CSTR1//
n=(log((tow/tow2)*((C1-C2)/(C0-C1))))/(log(C2/(C1)));
//Assume decomposition is second order//
k=(C0-C1)/(tow*((C1)^(2)));
Rate=k;
//Rate=k*Ca^(2)//
end Ex4_9;
