model Ex5_8
parameter Real Cr0(unit="No units")=0 "Composition of R in the initial";
parameter Real Cr1(unit="No units")=0.20 "Composition of R in the first reactor";
parameter Real Cs0(unit="No units")=0.3 "Composition of S in the initial";
parameter Real Cs1(unit="No units")=0.7 "Composition of S in the first reactor";
parameter Real Ca0(unit="No units")=1 "Composition of A in the initial";
parameter Real Ca1(unit="No units")=0.4 "Composition of A in the first reactor";
parameter Real Tow1(unit="min")=2.5 "Residence time in reactor 1";
parameter Real Tow2(unit="min")=10 "Residence time in reactor 2";
Real k1(unit="lit/(mol.min)") "Rate constant of the reaction in 1st reactor";
Real k2(unit="min^-1") "Rate constant of the reaction in 2nd reactor";
Real K(unit="No units") "k1/k2";
Real Ca2(unit="No units") "Composition of A at end of second reactor";
Real Cr2(unit="No units") "Composition of R at end of second reactor";
Real Cs2(unit="No units") "Composition of S at end of second reactor";
Real RHS(unit="No units") "Summation of exit composition";
Real LHS(unit="No units") "Summation of inlet composition";
//From the equations//
equation
K=((Cr1-Cr0)/(Cs1-Cs0))/(Ca1);
Tow1=(Ca0-Ca1)/((K*k2*((Ca1)^2))+(k2*Ca1));
k1=K*k2;
//For reactor 2//
Tow2=(Ca1-Ca2)/((k1*Ca2^(2))+(k2*Ca2));
Tow2=(Cr2-Cr1)/(k1*Ca2^(2));
Tow2=(Cs2-Cs1)/(k2*Ca2);
//To cross check//
Ca2+Cr2+Cs2=RHS;
Ca0+Cr0+Cs0=LHS;
//LHS=RHS//
//The units of k1 and k2 are different as given in book//
//The terms C doesnt have units as mentioned in the book//
end Ex5_8;
