model Ex6_1
parameter Real T1(unit="K")=298 "Standard temperature";
parameter Real T2(unit="K")=1273 "Temperature at which the reaction occurs";
parameter Real Cpa(unit="J/Mmol.K")=35 "Specific heat of reactant A";
parameter Real Cpb(unit="J/Mmol.K")=45 "Specific heat of reactant B";
parameter Real Cpr(unit="J/Mmol.K")=70 "Specific heat of product R";
parameter Real r(unit="No units")=2 "Stiochiometric coefficient";
parameter Real a(unit="No units")=1 "Stiochiometric coefficient";
parameter Real b(unit="No units")=1 "Stiochiometric coefficient";
parameter Real delH1(unit="J")=-50000 "Standard heat of reaction";
Real delCp(unit="J/Mmol.K") "Specific heat of reaction";
Real delH(unit="J") "Heat of reaction";
equation
//A+B gives 2R//
delCp=(r*Cpr)-(a*Cpa)-(b*Cpb);
delH=delH1+delCp*(T2-T1);
//Since delH is positive, the reaction is endothermic//
end Ex6_1;
