model Ex1_19
parameter Real E1(unit="cal/mol")=17982 "Activation energy without catalyst";
parameter Real E2(unit="cal/mol")=11980 "Activation energy catalyst";
parameter Real T(unit="K")=298 "Temperature";
parameter Real R(unit="cal/molK")=1.987 "Gas constant";
Real k2(unit="s^-1") "Rate constant for catalysed reaction";
//k1 be the rate of uncatalysed reaction//
//Assume k1=1//
//By comparing the rate equations for catalysed and uncatalysed reactions by Arrehenius equation//
//Final equation=k2/k1=exp(E1-E2/R*T)
equation
k2=exp((E1-E2)/(R*T));
//In presence of catalyst the rate of reaction will proceed k2 times faster than rate for uncatalysed reaction//
end Ex1_19;
