model Ex1_21
parameter Real T1(unit="K")=1000 "Temperature 1";
parameter Real T2(unit="K")=1100 "Temperature 2";
parameter Real R(unit="J/molK")=8.314 "Gas constant";
parameter Real k2(unit="mol/lit hr")=20 "Rate constant of reaction at Temperature 2";
Real E(unit="J/mol") "Activation energy";
//Rate at temperature 2 proceeds 20 times faster than rate at temperature 1//
equation
E=log(k2)*R/((1/T1)-(1/T2));
end Ex1_21;
