model Ex2_16
parameter Real[5] t(unit="min")={10,20,40,100,125} "Time";
parameter Real[5] Ca(unit="mol/lit")={0.0714,0.0556,0.0385,0.02,0.0167} "Concentration";
parameter Real Ca0(unit="mol/lit")=0.10 "Initial concentration";
Real[5] k1(unit="min^-1") "Rate constant for first order reaction";
Real[5] k2(unit="lit/mol.min") "Rate constant for second order reaction";
Real K(unit="lit/mol.min")  "Average rate constant";
equation
for i in 1:5 loop
  k1[i]=(1/t[i])*log(Ca0/Ca[i]);
end for;
//Since the values of k1 are not constant the reaction does not follow first order//
for i in 1:5 loop
  k2[i]=(1/t[i])*((1/Ca[i])-(1/Ca0));
end for;
K=sum(k2)/5;
end Ex2_16;
