model Ex2_18
parameter Real[4] t(unit="min")={10,20,30,50} "Time";
parameter Real[4] Ca(unit="mol/l")={0.740,0.635,0.546,0.405} "Concentration of A";
parameter Real Ca0(unit="mol/l")=0.860;
Real [4] k(unit="min^(-1)") "Rate constant";
Real K(unit="min^(-1)") "Average Rate constant";
Real thalf(unit="min") "Half life period";
//General equation for 1st order reaction k=1/t*ln(Ca0/Ca)
equation
for i in 1:4 loop
  k[i]=(1/t[i])*log(Ca0/Ca[i]);
end for;
K=(k[1]+k[2]+k[3]+k[4])/4;
//Half life period for first order reaction//
thalf=0.693/K;
//The value of thalf differs from that of the book value due to round off error//
end Ex2_18;
