model Ex2_20
parameter Real[8] t(unit="min")={10,20,30,40,50,60,70,80} "Time";
parameter Real[8]P(unit="kpa")={78.91,74.25,71.12,68.52,66.25,64.52,63.05,61.72} "Pressure";
parameter Real P1(unit="Torr")=84.25 "Initial Pressure";
Real [8] k(unit="(kpa*min)^-1") "Rate constant";
Real K(unit="(kpa*min)^-1") "Average Rate constant";
equation
for i in 1:8 loop
k[i]=(1/t[i])*(1/(2*P[i]-P1)-(1/P1));
end for;
K=sum(k)/8; 
//The value differs from that in book//
end Ex2_20;
